package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.PayRecordMapper;
import cn.wisenergy.model.app.PayRecord;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.dto.PayQueryDto;
import cn.wisenergy.model.vo.AddLimitVo;
import cn.wisenergy.service.app.AliPayService;
import cn.wisenergy.service.app.UserLimitService;
import cn.wisenergy.service.common.Common;
import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author 86187
 */
@Slf4j
@Service
public class AliPayServiceImpl implements AliPayService {
    private static final String CHARSET = "UTF-8";

    @Autowired
    private UserLimitService userLimitService;

    @Autowired
    private PayRecordMapper payRecordMapper;
    //appid
    @Value("${aliPay.APP_ID}")
    private String APP_ID;
    //公钥
    @Value("${aliPay.ALIPAY_PUBLIC_KEY}")
    private String ALIPAY_PUBLIC_KEY;
    //密钥
    @Value("${aliPay.PRIVATE_KEY}")
    private String PRIVATE_KEY;

    /***
     * pc端支付宝支付
     */
    @Override
    public R<String> doPost(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse) {
        if (null == payPageDto || null == payPageDto.getTotal()) {
            return R.error("人参不能为空!");
        }

        AlipayClient alipayClient = new DefaultAlipayClient(Common.PAY_URL, APP_ID, PRIVATE_KEY, "json", CHARSET, ALIPAY_PUBLIC_KEY, "RSA2");
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        String tradeNo = "21" + System.currentTimeMillis();
        int random=(int)(Math.random()*10+1);
        double amount = random/100;
        //支付成功跳转地址
        alipayRequest.setReturnUrl(Common.RETURN_URL_PC);
        //支付回调地址
        alipayRequest.setNotifyUrl(Common.NOTIFY_URL);
        //alipayRequest.setNotifyUrl("http://bga7hc.natappfree.cc/pay/aliPayCallBack.do");
        alipayRequest.setBizContent("{" +
                "\"out_trade_no\":\"" + tradeNo + "\"," +
                //"\"total_amount\":" + payPageDto.getTotal() + "," +
                "\"total_amount\":" + amount + "," +
                "\"subject\":\"充值\"," +
                "\"body\":\"充值\"," +
                "\"product_code\":\"FAST_INSTANT_TRADE_PAY\"" +
                "}");
        String form;
        //调用SDK生成表单
        try {
            AlipayTradePagePayResponse response = alipayClient.pageExecute(alipayRequest);
            form = response.getBody();
            System.out.println(form);
            httpResponse.setContentType("text/html;charset=UTF-8");
            //直接将完整的表单html输出到页面
            httpResponse.getWriter().write(form);
            httpResponse.getWriter().flush();
            httpResponse.getWriter().close();
            if (response.isSuccess()) {
                //生成预支付订单，充值结果设为失败（result=1）
                PayRecord payRecord = new PayRecord();
                payRecord.setMoney(payPageDto.getTotal());
                payRecord.setResult(1);
                payRecord.setTradeNo(tradeNo);
                payRecord.setType(payPageDto.getPayType());
                payRecord.setUserId(payPageDto.getUserId());
                payRecordMapper.add(payRecord);
                return R.ok("0", form);
            } else {
                return R.error("调用失败");
            }
        } catch (Exception e) {
            return R.ok(1, "调用失败");
        }
    }

    /***
     * 手机网页支付宝支付
     */
    @Override
    public R<String> wapAliPay(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse) {
        if (null == payPageDto || null == payPageDto.getTotal()) {
            return R.error("人参不能为空!");
        }
        AlipayClient alipayClient = new DefaultAlipayClient(Common.PAY_URL, APP_ID, PRIVATE_KEY, "json", CHARSET, ALIPAY_PUBLIC_KEY, "RSA2");
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        String tradeNo = "21" + System.currentTimeMillis();
        int random=(int)(Math.random()*10+1);
        double amount = random/100;
        //支付成功跳转地址
        alipayRequest.setReturnUrl(Common.RETURN_URL_WAP);
        //支付后回调地址
        alipayRequest.setNotifyUrl(Common.NOTIFY_URL);

        alipayRequest.setBizContent("{" +
                "\"out_trade_no\":\"" + tradeNo + "\"," +
                //"\"total_amount\":" + payPageDto.getTotal() + "," +
                "\"total_amount\":" + amount + "," +
                "\"subject\":\"充值\"," +
                "\"body\":\"充值\"," +
                "\"product_code\":\"QUICK_WAP_WAY\"" +
                "}");
        String form;
        //调用SDK生成表单
        try {
            AlipayResponse response = alipayClient.pageExecute(alipayRequest);
            form = response.getBody();
            System.out.println(form);
            httpResponse.setContentType("text/html;charset=UTF-8");
            //直接将完整的表单html输出到页面
            httpResponse.getWriter().write(form);
            httpResponse.getWriter().flush();
            httpResponse.getWriter().close();
            if (response.isSuccess()) {
                System.out.println("调用成功");
                //生成预支付订单，充值结果设为失败（result=1）
                PayRecord payRecord = new PayRecord();
                payRecord.setMoney(payPageDto.getTotal());
                payRecord.setResult(1);
                payRecord.setTradeNo(tradeNo);
                payRecord.setType(payPageDto.getPayType());
                payRecord.setUserId(payPageDto.getUserId());
                payRecordMapper.add(payRecord);
                return R.ok("0", form);
            } else {
                System.out.println("调用失败");
                return R.error("调用失败");
            }
        } catch (Exception e) {
            return R.ok(1, "调用失败");
        }
    }


    @Override
    public R<String> query(PayQueryDto payQueryDto) {
        return null;
    }

    /***
     * 支付后回调方法
     */
    @Override
    public void aliPayCallBack(HttpServletResponse response, HttpServletRequest request) throws Exception {
        PrintWriter out = response.getWriter();
        System.out.println("进入支付宝回调");
        //获取支付宝POST过来反馈信息
        Map<String, String> params = convertRequestParamsToMap(request); // 将异步通知中收到的待验证所有参数都存放到map中
        log.info("支付宝回调，{}", JSON.toJSONString(params));
        // 验证
        boolean flag = AlipaySignature.rsaCheckV1(params, ALIPAY_PUBLIC_KEY, CHARSET, "RSA2");
        // 获取支付宝的通知返回参数
        // 获取订单号
        String order_no = request.getParameter("out_trade_no");

        //获取订单状态
        String trade_status = request.getParameter("trade_status");
        // 验证成功
        if (!flag || !"TRADE_SUCCESS".equals(trade_status)) {
            out.print("failure");
            return;
        }
        //返回成功后修改订单充值结果为0,保存查询次数
        QueryWrapper<PayRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("trade_no", order_no);
        PayRecord payRecord = payRecordMapper.selectOne(queryWrapper);
        AddLimitVo addLimitVo = new AddLimitVo();
        addLimitVo.setTradeNo(order_no);
        addLimitVo.setPayMoney(payRecord.getMoney());
        addLimitVo.setPayType(1);
        addLimitVo.setUserId(payRecord.getUserId());
        if (payRecord.getResult() != 1) {
            out.print("failure");
            return;
        }
        R<Boolean> booleanR = userLimitService.addLimit(addLimitVo);
        if (booleanR.getCode() != 0) {
            out.print("failure");
            return;
        }
        out.print("success");
    }


    /***
     * 将request中的参数转换成Map
     */
    private static Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        Map<String, String> retMap = new HashMap<>();
        Set<Map.Entry<String, String[]>> entries = request.getParameterMap().entrySet();

        for (Map.Entry<String, String[]> entry : entries) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            int valLen = values.length;

            if (valLen == 1) {
                retMap.put(name, values[0]);
            } else if (valLen > 1) {
                StringBuilder sb = new StringBuilder();
                for (String val : values) {
                    sb.append(",").append(val);
                }
                retMap.put(name, sb.toString().substring(1));
            } else {
                retMap.put(name, "");
            }
        }

        return retMap;
    }

}
