package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.StaffMapper;
import cn.wisenergy.model.app.Staff;
import cn.wisenergy.model.dto.StaffDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.QueryVo;
import cn.wisenergy.model.vo.StaffVo;
import cn.wisenergy.service.app.StaffService;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class StaffServiceImpl implements StaffService {

    @Autowired
    private StaffMapper staffMapper;

    //初始密码
    private static final String PASSWORD="123456";

    /**
     * 禁用员工登录
     * @param staffId 用户id
     * @return true:成功 false：失败
     */
    @Override
    public R<Boolean> delete(Integer staffId) {
        log.info("StaffServiceImpl[].delete[].int.param:"+staffId);

        if (null==staffId) {
            R.error("输入参数为空");
        }

        int delete = staffMapper.delete(staffId);

        if (delete==0) {
            R.ok(1,false);
        }
        return R.ok(0,true);
    }

    /**
     * 获取员工信息集合
     * @param queryVo 查询信息
     * @return 员工信息集合
     */
    @Override
    public R<PageInfo<StaffDto>> getStaffList(QueryVo queryVo) {
        log.info("StaffServiceImpl[].getStaffList[].input.param:"+queryVo);
        if (null==queryVo) {
            return R.error("传入参数为空");
        }

        //创建参数容器
        Map<String, Object> map = new HashMap<>(4);

        Integer pageNum = queryVo.getPageNo();
        Integer pageSize = queryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            queryVo.setPageSize(10);
        }
        if (null == pageNum || pageNum == 0) {
            queryVo.setPageNo(1);
        }

        //将参数放入容器中
        if (null!=queryVo.getPageNo()||null!=queryVo.getPageSize()){
            map.put("pageNo", (queryVo.getPageNo() - 1) * queryVo.getPageSize());
            map.put("pageSize", queryVo.getPageSize());
        }
        map.put("staffName", queryVo.getStaffName());
        map.put("phone", queryVo.getPhone());

        //查询vip客户信息
        List<Staff> staffList = staffMapper.getStaffList(map);

        //转移客户信息至返回类中
        List<StaffDto> staffDtos = new ArrayList<>();
        for (Staff staff : staffList) {
            StaffDto staffDto = new StaffDto();
            BeanUtils.copyProperties(staff,staffDto);
            staffDtos.add(staffDto);
        }
        PageInfo<StaffDto> info = new PageInfo<>();
        info.setPageSize(null==queryVo.getPageSize()?0:queryVo.getPageSize());
        info.setPageNum(null==queryVo.getPageNo()?0:queryVo.getPageNo());
        info.setTotal(staffList.size());
        info.setList(staffDtos);

        return R.ok(0,info);
    }

    /**
     * 修改员工信息
     * @param staff 需要编辑的信息
     * @return true:成功 false：失败
     */
    @Override
    public R<Boolean> editStaff(StaffVo staff) {
        log.info("StaffServiceImpl[].editStaff[].input.param:"+staff);

        if (null==staff) {
            R.error("传入参数为空");
        }

        //将参数转移到staff对象中
        Staff staff2 = new Staff();
        BeanUtils.copyProperties(staff,staff2);

        int i = staffMapper.editStaff(staff2);

        if (i==0) {
            return R.ok(1,false);
        }

        return R.ok(0,true);
    }

    /**
     * 添加员工信息
     * @param staff 需要添加的员工信息
     * @return true：成功  false：失败
     */
    @Override
    public R<Boolean> addStaff(StaffVo staff) {
        log.info("StaffServiceImpl[].addStaff[].input.param:"+staff);

        if (null==staff) {
            return R.error("传入参数为空");
        }

        //创建参数容器map
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("loginName",staff.getLoginName());

        //查询管理者信息
        Staff staff3 = staffMapper.getStaff(map);
        if (null!=staff3) {
            return R.error("用户已存在");
        }

        //将参数转移到staff对象中
        Staff staff2 = new Staff();
        staff2.setIsDelete(0);
        staff2.setPassword(Md5Util.digestMD5(PASSWORD));
        BeanUtils.copyProperties(staff,staff2);

        int i = staffMapper.addStaff(staff2);

        if (i==0){
            return R.ok(1,false);
        }
        return R.ok(0,true);
    }
}
