package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.StringUtil;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.dto.UserDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.*;
import cn.wisenergy.service.app.StaffUserVipService;
import cn.wisenergy.service.common.UserVipManager;
import cn.wisenergy.service.common.VolunteerManager;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class StaffUserVipServiceImpl extends ServiceImpl<LocalMapper, Local> implements StaffUserVipService {

    @Autowired
    private StaffMapper staffMapper;

    @Autowired
    private StaffUserVipMapper staffUserVipMapper;

    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private ScoreInfoMapper scoreInfoMapper;

    @Autowired
    private LoginRecordMapper loginRecordMapper;

    @Autowired
    private UserLimitMapper userLimitMapper;

    @Autowired
    private PayRecordMapper payRecordMapper;

    @Autowired
    private VolunteerManager volunteerManager;

    @Autowired
    private UserVipManager userVipManager;

    @Autowired
    private LocalMapper localMapper;

    //初始密码
    private static final String PASSWORD = "123456";

    @Override
    public R<Boolean> staffLogin(AccountLoginVo loginVo) {
        log.info("StaffUserVipServiceImpl[].staffLogin[].input:param:" + loginVo);

        //判断参数是否为空
        if (null == loginVo || StringUtils.isBlank(loginVo.getUserName()) || StringUtils.isBlank(loginVo.getPassword())) {
            return R.error("账号或密码为空");
        }

        //创建参数容器map
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("loginName", loginVo.getUserName());

        //查询管理者信息
        Staff staff = staffMapper.getStaff(map);
        if (null == staff) {
            return R.error("用户不存在");
        }

        if (!staff.getPassword().equals(Md5Util.digestMD5(loginVo.getPassword()))) {
            return R.error("账号或者密码错误");
        }

        return R.ok(0, true);
    }

    @Override
    public R<PageInfo<UserInfoDto>> getList(UserVipQueryVo queryVo) {
        log.info("StaffUserVipServiceImpl[].getList[].input.param:" + queryVo);
        if (null==queryVo||null==queryVo.getStaffId()) {
            return R.error("入参为空");
        }
        List<StaffUserVip> listStaff = staffUserVipMapper.getList(queryVo.getStaffId());

        //创建参数容器
        Map<String, Object> map = new HashMap<>(4);

        //将参数放入容器中

        if (null!=queryVo.getPageNo()||null!=queryVo.getPageSize()){
            map.put("pageNo", (queryVo.getPageNo() - 1) * queryVo.getPageSize());
            map.put("pageSize", queryVo.getPageSize());
        }
        map.put("userName", queryVo.getUserName());
        map.put("phone", queryVo.getPhone());
        map.put("list",listStaff);

        //查询用户数据
        List<User> list1 = usersMapper.getUserByStaffId(map);
        List<UserInfoDto> list = new ArrayList<>();

        //将集合遍历拿出用户id查询成绩信息
        for (User user : list1) {
            UserInfoDto userInfoDto = new UserInfoDto();

            //查询相关信息
            ScoreInfo scoreInfo = scoreInfoMapper.getByUserId(user.getId());
            if (null != scoreInfo) {
                userInfoDto.setCultureGrade(scoreInfo.getCultureGrade().toString());
                userInfoDto.setMajorGrade(null==scoreInfo.getMajorGrade()?"":scoreInfo.getMajorGrade().toString());
            }
            LoginRecord loginRecord = loginRecordMapper.getById(user.getId());
            if (null != loginRecord) {
                userInfoDto.setLastLoginTime(loginRecord.getUpdateTime());
                userInfoDto.setIp(loginRecord.getIp());
            }
            UserLimit userLimit = userLimitMapper.getByUserId(user.getId());

            if (null != userLimit) {
                userInfoDto.setQueryLimit(userLimit.getUsableLimit());
            }
            List<PayRecord> byId = payRecordMapper.getById(user.getId());

            //计算充值卡充值次数
            Integer rechargeTimes = 0;

            //支付宝充值总金额
            Integer alipayMoney = 0;

            //微信充值总金额
            Integer weChatMoney = 0;

            if (!CollectionUtils.isEmpty(byId)) {

                for (PayRecord payRecord : byId) {
                    if (payRecord.getType() == 1) {
                        alipayMoney += Integer.valueOf(null == payRecord.getMoney() ? 0 : payRecord.getMoney());
                    }

                    if (payRecord.getType() == 2) {
                        weChatMoney += Integer.valueOf(null == payRecord.getMoney() ? 0 : payRecord.getMoney());
                    }

                    if (payRecord.getType() == 3) {
                        rechargeTimes += 1;
                    }
                }
            }
            userInfoDto.setWeChatMoney(String.valueOf(weChatMoney));
            userInfoDto.setAlipayMoney(String.valueOf(alipayMoney));
            userInfoDto.setRechargeTimes(rechargeTimes);

            //将消息进行同步
            BeanUtils.copyProperties(user, userInfoDto);
            userInfoDto.setUserId(user.getId());
            userInfoDto.setRegisterTime(user.getCreateTime());
            list.add(userInfoDto);
        }

        PageInfo<UserInfoDto> info = new PageInfo<>();
        info.setPageSize(null==queryVo.getPageSize()?0:queryVo.getPageSize());
        info.setPageNum(null==queryVo.getPageNo()?0:queryVo.getPageNo());
        info.setTotal(usersMapper.getUserNumbers(map));
        info.setList(list);

        return R.ok(info);
    }

    @Override
    public R<Boolean> addUserByPhone(Integer staffId, String phone) {
        log.info("StaffUserVipServiceImpl[].addUserByPhone[].input.param:" +staffId,phone);

        return addPhone(staffId,phone);
    }

    @Override
    public R<List<Local>> getLocal() {
        List<Local> list = localMapper.getList();

        if (CollectionUtils.isEmpty(list)) {
            return R.error("入参为空");
        }

        return R.ok(0,list);
    }

    @Override
    public R<Boolean> addUserVolunteer(String ids,Integer userId,String name) {
        log.info("StaffUserVipServiceImpl[].addUserVolunteer[].input.param:" +ids,userId);

        if (StringUtils.isBlank(ids)||null==userId) {
            return R.error("入参为空");
        }

        //通过id获取用户信息
        User byId = usersMapper.getById(userId);

        if (null==byId) {
            return R.error("该用户不存在");
        }

        ScoreInfo byUserId = scoreInfoMapper.getByUserId(userId);

        R<Boolean> booleanR = userVipManager.saveUserVolunteer(byId,ids,byUserId,name);

        if (!booleanR.getData()) {
            return R.error("保存失败");
        }
        return R.ok(0,true);
    }


    private R<Boolean> addPhone(Integer staffId,String phone){
        if (null==staffId|| StringUtils.isBlank(phone)) {
            return R.error("入参为空");
        }
        //进行vip客户和员工绑定
        User byPhone =userVipManager.checkPhone(phone);
        if (null==byPhone) {
            return R.error("信息添加失败");
        }
        R<Boolean> booleanR = userVipManager.addPhone1(staffId, byPhone);

        //判断数据是否添加成功
        if (booleanR.getCode()!=0) {
            return R.error("关系绑定失败");
        }

        return R.ok(0,true);
    }

    @Override
    public R<Boolean> downExcel(UserVipQueryVo queryVo, HttpServletResponse response) {
        log.info("StaffUserVipServiceImpl[].downExcel[].input.param:"+queryVo);
        if (null==queryVo||null==queryVo.getStaffId()) {
            return R.error("入参为空");
        }

        queryVo.setPageSize(null);
        queryVo.setPageNo(null);

        //获取员工名称
        Staff byId = staffMapper.getById(queryVo.getStaffId());
        if (null==byId) {
            return R.error("该员工不存在");
        }
        String staffName=byId.getStaffName();

        //生成Excel
        try {
            //  设置内容格式 以及 编码方式
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");

            List<UserInfoDto> list=getList(queryVo).getData().getList();

            //  使用java8新特性的stream流去处理数据，把空的数据过滤掉
            List<UserDto> resultBo = list.stream().filter(Objects::nonNull)
                    .map(t -> {
                        return UserDto.builder()
                                .registerTime(t.getRegisterTime())
                                .source(t.getSource()==1?"PC":"APP")
                                .userName(t.getUserName())
                                .phone(t.getPhone())
                                .lastLoginTime(t.getLastLoginTime())
                                .school(t.getSchool())
                                .examType(t.getExamType()==1?"文化生":t.getExamType()==2?"美术生":t.getExamType()==3?"体育生":"文学编导考生")
                                .sex(t.getSex()==0?"男":"女")
                                .rechargeTimes(t.getRechargeTimes())
                                .weChatMoney(t.getWeChatMoney())
                                .alipayMoney(t.getAlipayMoney())
                                .lastLoginTime(t.getLastLoginTime())
                                .cultureGrade(t.getCultureGrade())
                                .majorGrade(t.getMajorGrade())
                                .build();
                    }).collect(Collectors.toList());

            //创建文件名称
            Long lon = System.currentTimeMillis();

            response.setHeader("Content-disposition", "attachment;filename=" + lon + ".xlsx");

            //  sheet名称
            EasyExcel.write(response.getOutputStream(), UserDto.class).sheet(staffName+lon.toString()).doWrite(resultBo);
            return R.ok(0,true);
        } catch (Exception e) {
            return R.ok(1,false);
        }
    }
}