package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.PayRecordMapper;
import cn.wisenergy.model.app.PayRecord;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.vo.AddLimitVo;
import cn.wisenergy.service.app.TestWxPayService;
import cn.wisenergy.service.app.UserLimitService;
import cn.wisenergy.service.util.MapToXmlUtils;
import cn.wisenergy.service.util.WxPayUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.*;

import static com.baomidou.mybatisplus.core.toolkit.Constants.MD5;


/**
 * @author chengyan
 */
@Service
@Slf4j
public class TestWxPayServiceImpl implements TestWxPayService {
    //统一下单接口链接
    public static String unifiedOrderUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";


    @Autowired
    private UserLimitService userLimitService;
    @Autowired
    private PayRecordMapper payRecordMapper;

    //appid
    @Value("${wxPay.APP_ID}")
    private String appid;
    //商户id
    @Value("${wxPay.MCH_ID}")
    private String mchid;
    //商户id
    @Value("${wxPay.PRIVATE_KEY}")
    private String key;
    //小程序appid
    @Value("${wxPay.Applets_ID}")
    private String Applets_ID;
    //小程序密钥
    @Value("${wxPay.SECRT_KEY}")
    private String secrt_key;


    /***
     * pc微信支付总流程
     */
    @Override
    public R<Map<String, String>> wxPay(PayPageDto payPageDto, HttpServletResponse response) {
        if (null == payPageDto || null == payPageDto.getTotal()) {
            return R.error("入参不能为空");
        }
        String tradeNo = "21" + System.currentTimeMillis();
        String product_id = "10" + System.currentTimeMillis();
        String time_expire=WxPayUtil.getOrderExpireTime(2*60*1000L);
        //生成预支付订单，充值结果设为失败（result=1）
        try {
            //生成【统一下单API】所需参数的接口
            String orderInfo = WxPayUtil.createOrderInfo(payPageDto,tradeNo, product_id,time_expire, appid, mchid, key);
            System.out.println(orderInfo);
            //调用统一下单接口
            Map<String, String> map = unifiedOrder(unifiedOrderUrl,orderInfo);
            String code_url = map.get("code_url");
            log.info("支付返回信息：", map.get("return_msg"));
            if (map!=null && "SUCCESS".equals(map.get("return_code")) && "SUCCESS".equals(map.get("result_code"))) {
                PayRecord payRecord = new PayRecord();
                payRecord.setMoney(payPageDto.getTotal());
                payRecord.setResult(1);
                payRecord.setTradeNo(tradeNo);
                payRecord.setType(payPageDto.getPayType());
                payRecord.setUserId(payPageDto.getUserId());
                payRecordMapper.add(payRecord);
            }
            Map<String, String> objMap = new HashMap<>();
            System.out.println("code_url：" + code_url);
            objMap.put("tradeNo",tradeNo);
            objMap.put("time_expire",time_expire);
            objMap.put("code_url",code_url);
            return R.ok("0", objMap);
        } catch (Exception e) {
            e.printStackTrace();
            return R.error("获取code_url失败");
        }
    }

    /***
     * h5微信支付总流程
     */
    @Override
    public R<String> h5WxPay(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse response) {
        if (null == payPageDto || null == payPageDto.getTotal()) {
            return R.error("入参不能为空");
        }
        String tradeNo = "21" + System.currentTimeMillis();
        //生成预支付订单，充值结果设为失败（result=1）
        try {
            //生成【统一下单API】所需参数的接口
            String orderInfo = WxPayUtil.createOrderInfoH5(payPageDto,tradeNo, request, appid, mchid, key);
            System.out.println(orderInfo);
            //调用统一下单接口
            Map<String, String> map = unifiedOrder(unifiedOrderUrl,orderInfo);
            String urlString = URLEncoder.encode("http://111.203.232.171:8999/#/history", "GBK");
            String mweb_url = map.get("mweb_url") + "&redirect_url=" + urlString;
            log.info("返回信息：", map.get("return_msg"));
            if (map!=null && "SUCCESS".equals(map.get("return_code")) && "SUCCESS".equals(map.get("result_code"))) {
                PayRecord payRecord = new PayRecord();
                payRecord.setMoney(payPageDto.getTotal());
                payRecord.setResult(1);
                payRecord.setTradeNo(tradeNo);
                payRecord.setType(payPageDto.getPayType());
                payRecord.setUserId(payPageDto.getUserId());
                payRecordMapper.add(payRecord);
            }
            return R.ok("0", mweb_url);
        } catch (Exception e) {
            e.printStackTrace();
            return R.error("获取mweb_url失败");
        }
    }


    /***
     * 小程序微信支付总流程
     */
    @Override
    public R<SortedMap<String, String>> WxPayApplets(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse response) {
        if (null == payPageDto || null == payPageDto.getTotal() || null == payPageDto.getCode()) {
            return R.error("入参不能为空");
        }
        SortedMap<String, String> mapParams = new TreeMap<>();
        //随机字符串
        String nonce_str = RandomStringUtils.randomAlphanumeric(16);
        String tradeNo = "21" + System.currentTimeMillis();
        //生成预支付订单，充值结果设为失败（result=1）
        try {
            //生成【统一下单API】所需参数的接口
            String orderInfo = WxPayUtil.createOrderInfoWx(payPageDto, tradeNo, nonce_str, Applets_ID,secrt_key, mchid, key);
            System.out.println(orderInfo);
            //调用统一下单接口
            Map<String, String> map = unifiedOrder(unifiedOrderUrl,orderInfo);
            String return_msg = map.get("return_msg");
            log.info("支付返回信息：", return_msg);
            if ("SUCCESS".equals(map.get("return_code")) && "SUCCESS".equals(map.get("result_code"))) {
                PayRecord record = new PayRecord();
                record.setMoney(payPageDto.getTotal());
                record.setResult(1);
                record.setTradeNo(tradeNo);
                record.setType(payPageDto.getPayType());
                record.setUserId(payPageDto.getUserId());
                payRecordMapper.add(record);
                //返回的预付单信息,小程序端使用
                String prepay_id = map.get("prepay_id");
                mapParams.put("appId", Applets_ID);
                mapParams.put("nonceStr", nonce_str);
                mapParams.put("package", "prepay_id=" + prepay_id);
                Long timeStamp = new Date().getTime();
                //这边要将返回的时间戳转化成字符串，不然小程序端调用wx.requestPayment方法会报签名错误
                mapParams.put("timeStamp", timeStamp + "");
                mapParams.put("signType", MD5);
                //二次签名
                String paySign = WxPayUtil.createSign(mapParams,key);
                mapParams.put("paySign", paySign);
            }
            return R.ok("0",mapParams);
        } catch (Exception e) {
            e.printStackTrace();
            return R.error("获取mweb_url失败");
        }
    }


    /***
     * 微信统一下单
     */
    public Map<String, String> unifiedOrder(String url,String info) throws Exception {
        HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
        //加入数据
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);

        BufferedOutputStream buffOutStr = new BufferedOutputStream(conn.getOutputStream());
        buffOutStr.write(info.getBytes(StandardCharsets.UTF_8));
        buffOutStr.flush();
        buffOutStr.close();

        //获取输入流
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));

        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        return MapToXmlUtils.xmlToMap(sb.toString());
    }


    /***
     * 微信支付成功回调
     */
    @Override
    public void wxPayCallBack(HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("进入微信回调");
        BufferedOutputStream out = new BufferedOutputStream(response.getOutputStream());
        InputStream inStream = request.getInputStream();
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        // 获取微信调用我们notify_url的返回信息
        String result = new String(outSteam.toByteArray(), StandardCharsets.UTF_8);
        Map<String, String> map = MapToXmlUtils.xmlToMap(result);
        String resXml;
        if (map.get("result_code").equalsIgnoreCase("SUCCESS")) {
            //返回成功后修改订单充值结果为0,保存查询次数
            QueryWrapper<PayRecord> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("trade_no", map.get("out_trade_no"));
            PayRecord payRecord = payRecordMapper.selectOne(queryWrapper);
            AddLimitVo addLimitVo = new AddLimitVo();
            addLimitVo.setTradeNo(map.get("out_trade_no"));
            addLimitVo.setPayMoney(payRecord.getMoney());
            addLimitVo.setPayType(2);
            addLimitVo.setUserId(payRecord.getUserId());
            if (payRecord.getResult() == 1) {
                R<Boolean> booleanR = userLimitService.addLimit(addLimitVo);
                if (booleanR.getCode() == 1) {
                    resXml = "<xml>" + "<return_code><![CDATA[SUCCESS]]></return_code>"
                            + "<return_msg><![CDATA[OK]]></return_msg>" + "</xml> ";

                } else {
                    log.info("支付失败,错误信息：" + map.get("err_code"));
                    resXml = "<xml>" + "<return_code><![CDATA[FAIL]]></return_code>"
                            + "<return_msg><![CDATA[报文为空]]></return_msg>" + "</xml> ";
                }

            }else{
                resXml = "<xml>" + "<return_code><![CDATA[SUCCESS]]></return_code>"
                        + "<return_msg><![CDATA[OK]]></return_msg>" + "</xml> ";
            }
            out.write(resXml.getBytes());
            out.flush();
            out.close();

        } else {
            log.info("失败");
        }
    }

    /***
     * 订单状态查询
     */
    @Override
    public R<Map<String,String>> wxQuery(String out_trade_no){
        QueryWrapper<PayRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("trade_no",out_trade_no);
        PayRecord payRecord = payRecordMapper.selectOne(queryWrapper);
        Map<String, String> result = new HashMap<>();
        result.put("return_code", "SUCCESS");
        result.put("result_code", "SUCCESS");
        result.put("trade_state", "SUCCESS");
        if(payRecord.getResult()==0){
            return R.ok(0,result);
        }else{
            return R.error("支付失败");
        }
    }

}
