package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.expection.BaseException;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.SchemeMapper;
import cn.wisenergy.mapper.VolunteerMapper;
import cn.wisenergy.model.app.SchemeInfo;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.service.app.VolunteerService;
import cn.wisenergy.service.common.VolunteerListener;
import cn.wisenergy.service.common.VolunteerManager;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 86187
 * @ Description: 志愿接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/8 9:44
 */
@Service
@Slf4j
public class VolunteerServiceImpl extends ServiceImpl<VolunteerMapper, Volunteer> implements VolunteerService {
    @Autowired
    private VolunteerMapper volunteerMapper;

    @Autowired
    private SchemeMapper schemeMapper;

    @Autowired
    private VolunteerService volunteerService;

    @Autowired
    private VolunteerManager volunteerManager;

    @Override
    public R<Boolean> batchAdd(List<Volunteer> list) {
        return null;
    }

    @Override
    public void excelAdd(MultipartFile file, Integer type, String schemeName, String fileUrl, HttpServletResponse response) throws IOException {
        if (file == null || file.isEmpty() || null == type || StringUtils.isBlank(schemeName) ||
                StringUtils.isBlank(fileUrl)) {
            throw new BaseException("操作错误");
        }
        //判断文件类型=
        boolean valid = this.validContentType(file.getOriginalFilename());
        if (!valid) {
            throw new BaseException("请传入Excel文件");
        }
        VolunteerListener excelListener = new VolunteerListener();

        //2.读取数据进行入库操作
        EasyExcel.read(file.getInputStream(), Volunteer.class, excelListener).sheet().doRead();
        List<Volunteer> list = excelListener.getList();
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseException("写入方案数据失败!");
        }

        //3、保存方案和志愿信息
        SchemeInfo schemeInfo = new SchemeInfo();
        schemeInfo.setSchemeName(schemeName);
        schemeInfo.setType(type);
        schemeInfo.setFileUrl(fileUrl);
        schemeInfo.setUploadTime(new Date());
        schemeInfo.setIsDelete(0);
        int scheme = schemeMapper.getByType(type);
        if (scheme > 0) {
            throw new RuntimeException("该类型方案已经存在!");
        }

        volunteerManager.saveSchemeAndVolunteer(schemeInfo, list);
    }

    @Override
    public void ceshi(MultipartFile file, HttpServletResponse response) throws IOException {
        if (file == null || file.isEmpty()) {
            throw new BaseException("操作错误");
        }

        VolunteerListener excelListener = new VolunteerListener();

        //判断文件类型=
        boolean valid = this.validContentType(file.getOriginalFilename());
        if (!valid) {
            throw new BaseException("请传入Excel文件");
        }
        //2.读取数据进行入库操作
        EasyExcel.read(file.getInputStream(), Volunteer.class, excelListener).sheet().doRead();
        List<Volunteer> list = excelListener.getList();

        //3、保存方案和志愿信息
        SchemeInfo schemeInfo = new SchemeInfo();
        schemeInfo.setSchemeName("本科文化一批");
        schemeInfo.setType(1);
        schemeInfo.setUploadTime(new Date());
        schemeInfo.setIsDelete(0);

        volunteerManager.saveSchemeAndVolunteer(schemeInfo, list);
        log.info("导入方案数据成功!");
    }

    @Override
    public void excelTemplate(HttpServletResponse response) throws IOException {
        //构造假数据
        List<Volunteer> residents = this.mockData();
        //excel导出
        this.download(response, Volunteer.class, residents, "居民管理模板", "居民管理");
    }

    /**
     * 判断文件类型
     *
     * @param fileName 文件名
     * @return true or false
     */
    public boolean validContentType(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return false;
        }
        String substring = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("xlsx".equals(substring) || "xls".equals(substring)) {
            return true;
        }
        return false;
    }

    private List<Volunteer> mockData() {
        ArrayList<Volunteer> residents = new ArrayList<>(2);
        //模拟两条假数据
        for (int i = 0; i < 2; i++) {
            Volunteer volunteer = Volunteer.builder()
                    .majorName("北京大学" + i)
                    .academy("计算机学院" + i)
                    .courseDemand("物理" + i + 1)
                    .nature("全日制")
                    .yearLimit(4)
                    .planNum(2 + i)
                    .castArchivesNum(3 + i)
                    .launchNum(4 + i)
                    .lowestMark(600.00 + i * 10)
                    .lowestRank("100" + i * 10)
                    .build();
            residents.add(volunteer);
        }
        return residents;
    }

    /**
     * 导出数据
     *
     * @param response
     * @param clazz     实体类对象的类型
     * @param data      导出的数据
     * @param fileName  工作簿文件名
     * @param sheetName 工作表文件名
     * @throws IOException
     */
    private void download(HttpServletResponse response, Class clazz, List data, String fileName, String sheetName) throws IOException {
        if (StringUtils.isBlank(fileName)) {
            fileName = "测试";
        }
        if (StringUtils.isBlank(sheetName)) {
            sheetName = "模板";
        }
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("NewContent-disposition", "attachment;filename=" + fileName + ".xlsx");

        EasyExcel.write(response.getOutputStream(), clazz).sheet(sheetName).doWrite(data);
    }
}
