package cn.wisenergy.service.common;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.StringUtil;
import cn.wisenergy.mapper.SchemeRecordMapper;
import cn.wisenergy.mapper.StaffUserVipMapper;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserVipCommitVo;
import cn.wisenergy.service.app.UserService;
import cn.wisenergy.service.app.UserVolunteerService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
public class UserVipManager {

    @Autowired
    private StaffUserVipMapper staffUserVipMapper;

    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private SchemeRecordMapper schemeRecordMapper;

    @Autowired
    private UserVolunteerService userVolunteerService;

    @Transactional
    public R<Boolean> addPhone1(Integer staffId,User user){

        StaffUserVip staffUserVip = new StaffUserVip();
        staffUserVip.setStaffId(staffId);
        staffUserVip.setUserVipId(user.getId());
        staffUserVip.setIsDelete(0);
        int add = staffUserVipMapper.add(staffUserVip);

        //判断数据是否添加成功
        if (add==0) {
            return R.error("信息添加失败");
        }

        //将客户修改为vip
        user.setIsVip(1);
        int edit = usersMapper.edit(user);
        if (edit==0) {
            return R.error("信息修改失败");
        }

        return R.ok(0,true);
    }

    public User checkPhone(String phone) {

        //根据电话号码查询用户
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", phone);
        queryWrapper.eq("is_delete", 0);
        User user = usersMapper.selectOne(queryWrapper);
        if (null != user) {
            return user;
        }
        return null;
    }

    /**
     * 保存方案查询记录和关联关系
     *
     * @return true 成功  false 失败
     */
    @Transactional(rollbackFor = Exception.class)
    public R<Boolean> saveUserVolunteer(User user, String ids, ScoreInfo scoreInfo, String name) {

        //1、保存方案查询记录
        SchemeQueryRecord schemeQueryRecord = new SchemeQueryRecord();
        schemeQueryRecord.setMajorName(name);
        schemeQueryRecord.setStudentType(user.getExamType());
        schemeQueryRecord.setUserId(user.getId());
        schemeQueryRecord.setIsDelete(0);
        if (null == scoreInfo.getMajorGrade()) {
            schemeQueryRecord.setMajorScore("0");
        } else {
            schemeQueryRecord.setMajorScore(scoreInfo.getMajorGrade().toString());
        }
        schemeQueryRecord.setScore(scoreInfo.getCultureGrade().toString());

        //保存方案查询记录
        int count = schemeRecordMapper.add(schemeQueryRecord);
        if (count == 0) {
            return R.error("保存方案查询记录失败!");
        }
        List<UserVolunteer> volunteerList = new ArrayList<>();

        List<Integer> professionIds = StringUtil.strToArray(ids);
        for (Integer id : professionIds) {
            UserVolunteer userVolunteer = new UserVolunteer();
            userVolunteer.setSchemeRecordId(schemeQueryRecord.getId());
            userVolunteer.setUserId(user.getId());
            userVolunteer.setVolunteerId(id);
            volunteerList.add(userVolunteer);
        }

        //保存方案志愿关联关系
        boolean bool = userVolunteerService.saveBatch(volunteerList);
        if (!bool) {
            return R.error("保存方案志愿关联关系失败!");
        }

        return R.ok(0,true);
    }
}
