package cn.wisenergy.service.common;

import cn.wisenergy.model.app.Volunteer;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Head;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * Excel批量添加社区居民  监听器
 *
 * @author 86187
 */
@Slf4j
public class VolunteerListener extends AnalysisEventListener<Volunteer> {

    private List<Volunteer> list=new ArrayList<>();
    private final int batch = 50000;

    /**
     * 导入模板头内容
     */
    private Map<Integer, String> headMap = new HashMap<>();

    /**
     * 结果标记 默认错误
     */
    private boolean isCorrectFormat = true;


    /**
     * 这个每一条数据解析都会来调用  ==
     *
     * @param volunteer       志愿信息
     * @param analysisContext
     */
    @Override
    public void invoke(Volunteer volunteer, AnalysisContext analysisContext) {
        if (!isCorrectFormat) {
            //格式是否正确
            return;
        }
        log.info("解析到一条志愿数据>>>>>>>>>>：{}", volunteer);
        //此处做校验  本次没有校验
        if (volunteer != null) {
            volunteer.setIsDelete(0);
            volunteer.setCreateTime(new Date());
            volunteer.setUpdateTime(new Date());
            if (StringUtils.isEmpty(volunteer.getMajorName())) {
                throw new RuntimeException("专业不能为空！");
            }

            if (StringUtils.isEmpty(volunteer.getAcademy())) {
                throw new RuntimeException("院校不能为空！");
            }
            if (StringUtils.isEmpty(volunteer.getLowestRank())) {
                volunteer.setLowestRank("--");
            }

            if (StringUtils.isEmpty(volunteer.getCourseDemand())) {
                throw new RuntimeException("选考科目要求不能为空！");
            }

            if (StringUtils.isEmpty(volunteer.getNature())) {
                throw new RuntimeException("学校不能为空！");
            }

            if (null == volunteer.getYearLimit()) {
                throw new RuntimeException("学年制不能为空！");
            }

            if (null == volunteer.getPlanNum()) {
                throw new RuntimeException("计划数数不能为空！");
            }

            if (StringUtils.isEmpty(volunteer.getLowestMark())) {
                throw new RuntimeException("最低分不能为空！");
            }

            list.add(volunteer);
        }
    }

    /**
     * 所有数据解析完成了 都会来调用
     *
     * @param analysisContext
     */
    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
//        log.info("doAfterAllAnalysed解析玩一个志愿sheet工作表>>>>>>>>>>");
//        //如果集合不为空
//        if (!CollectionUtils.isEmpty(list)) {
//            log.info("批量插入志愿数据，条数为>>>>>>>>>>：{}", list.size());
//            if (list.size() > 0) {
//                volunteerService.saveBatch(list);
//            }
//        }
    }


    public List<Volunteer> getList() {
        List<Volunteer> result = new ArrayList<>();
        result.addAll(list);
        return result;
    }

    public void setList(List<Volunteer> list) {
        this.list = list;
    }


    /**
     * 校验导入模板表头是否正确
     *
     * @param headMap 表头
     * @param context
     */
    @Override
    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        //是否手动传入表头信息 没有则自动读取实体类头信息
        try {
            if (this.headMap == null || this.headMap.size() <= 0) {
                Map<Integer, Head> map = context.currentReadHolder().excelReadHeadProperty().getHeadMap();
                for (int i = 0; i < map.size(); i++) {
                    //封装成headMap
                    this.headMap.put(map.get(i).getColumnIndex(), map.get(i).getHeadNameList().get(0));
                }
            }
        } catch (Exception e) {
            isCorrectFormat = false;
            throw new RuntimeException("导入失败，请联系管理员！");
        }

        if (this.headMap == null || headMap == null || this.headMap.size() != headMap.size()) {
            isCorrectFormat = false;
            throw new RuntimeException("导入表的表头与模板表头不符!");
        } else {
            for (int i = 0; i < this.headMap.size(); i++) {
                //循环遍历判断表格头是否一一对应
                if (!this.headMap.get(i).equals(headMap.get(i))) {
                    isCorrectFormat = false;
                    throw new RuntimeException("导入表的表头与模板表头不符!");
                }
            }
        }

    }

}
