package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Banner;
import cn.wisenergy.model.dto.BannerDto;
import cn.wisenergy.model.vo.AdvertisingQueryVo;
import cn.wisenergy.service.app.BannerService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author 86187
 * @ Description: 管理端-广告管理
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:43
 */
@RestController
@Api(tags = "管理端-广告管理")
@RequestMapping("/banner")
@Slf4j
public class BannerController {
    @Autowired
    private BannerService bannerService;

    @ApiOperation(value = "广告添加", notes = "广告添加", httpMethod = "POST")
    @ApiImplicitParam(name = "advertising", value = "广告数据", dataType = "Banner")
    @PostMapping("/add")
    public R<Boolean> add(@RequestBody Banner advertising) {
        log.info("BannerController[].add[].input.param:advertising:" + advertising);
        return bannerService.add(advertising);
    }

    @ApiOperation(value = "广告查询", notes = "广告查询", httpMethod = "POST")
    @ApiImplicitParam(name = "advertisingQueryVo", value = "分页数据", dataType = "AdvertisingQueryVo")
    @PostMapping("/getList")
    public R<PageInfo<BannerDto>> getList(@RequestBody AdvertisingQueryVo advertisingQueryVo) {
        log.info("BannerController[].add[].input.param:advertisingQueryVo:" + advertisingQueryVo);
        return bannerService.getList(advertisingQueryVo);
    }

    @ApiOperation(value = "查看详情", notes = "查看详情", httpMethod = "GET")
    @ApiImplicitParam(name = "id", value = "广告id", dataType = "int")
    @GetMapping("/getById")
    public R<Banner> getById(Integer id) {
        log.info("BannerController[].getById[].input.param:id" + id);
        return bannerService.getById(id);

    }

    @ApiOperation(value = "广告投放", notes = "广告投放", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "广告id", dataType = "int", required = true),
            @ApiImplicitParam(name = "status", value = "广告状态:0：暂停中 1：投放中", dataType = "int", required = true)
    })
    @GetMapping("/putIn")
    public R<Boolean> editStatus(Integer id, Integer status) {
        log.info("BannerController[]editStatus[]input.param:id,status{}" + id, status);
        return bannerService.editStatus(id, status);
    }

    @ApiOperation(value = "广告编辑", notes = "广告编辑", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "advertising", value = "广告修改数据", dataType = "Banner"),
    })
    @PostMapping("/edit")
    public R<Boolean> edit(@RequestBody Banner advertising) {
        log.info("BannerController[].edit[].input.param:advertising:" + advertising);
        return bannerService.edit(advertising);
    }


    @ApiOperation(value = "获取顶部/底部广告", notes = "获取顶部/底部广告", httpMethod = "GET")
    @ApiImplicitParam(name = "type", value = "广告类型：1：顶部 2：底部", dataType = "int", required = true)
    @GetMapping("/getBanners")
    public R<List<Banner>> getBanners(Integer type) {
        log.info("BannerController[]getBanners[]input.param.type:" + type);
        if (null == type) {
            return R.error("入参不能为空!");
        }
        return bannerService.getTopBanners(type);
    }

    @ApiOperation(value = "删除广告", notes = "删除广告", httpMethod = "GET")
    @ApiImplicitParam(name = "id", value = "广告id", dataType = "int", required = true)
    @GetMapping("/delBanner")
    public R<Boolean> delBanner(Integer id) {
        log.info("BannerController[]delBanner[]input.param.id:" + id);
        if (null == id) {
            return R.error("入参不能为空!");
        }
        return bannerService.delBanner(id);
    }
}
