package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.RefillCard;
import cn.wisenergy.model.dto.RefillCardDto;
import cn.wisenergy.service.app.RefillCardService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@Api(tags = "充值卡管理")
@RestController
@RequestMapping("/refillCard")
@Slf4j
public class RefillCardController {

    @Autowired
    private RefillCardService refillCardService;

    @ApiOperation(value = "添加充值卡",notes = "添加充值卡",httpMethod = "POST")
    @ApiImplicitParam(name = "numbers",value = "卡的数量",dataType="int",required = true)
    @PostMapping("/manage")
    public R<Boolean> manage(Integer numbers){
        log.info("RefillCardController[].manage[].input.param,numbers"+numbers);

        //创建对象参数
        RefillCard refillCard = new RefillCard();
        refillCard.setCardNumber(numbers);
        return  refillCardService.add(refillCard);
    }

    @ApiOperation(value = "激活充值卡",notes = "激活充值卡",httpMethod = "POST")
    @ApiImplicitParam(name = "batchNumber",value = "批次号",dataType = "string",required = true)
    @PostMapping("/update")
    public R<Boolean> update(String batchNumber){
        log.info("RefillCardController[].manage[].input.param,batchNumber"+batchNumber);
        return refillCardService.update(batchNumber);
    }

    @ApiOperation(value = "充值卡查询",notes = "充值卡查询",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo",value = "页数",dataType="int"),
            @ApiImplicitParam(name = "pageSize",value = "每页显示条数",dataType="int")
    })
    @GetMapping("/select")
    public R<PageInfo<RefillCardDto>> select(Integer pageNo, Integer pageSize){
        log.info("RefillCardController[].select[].input.param.parampageNo,pageSize"+pageNo,pageSize);
        return refillCardService.getList(pageNo, pageSize);
    }

    @ApiOperation(value = "生成卡片",notes = "生成卡片",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "充值卡id",dataType="int"),
    })
    @GetMapping("/createCard")
    public R<Boolean> createCard(Integer id){
        log.info("RefillCardController[].createCard[].input.param:id"+id);
        return refillCardService.createCard(id);
    }

    @ApiOperation(value = "充值卡导出",notes = "充值卡导出",httpMethod = "GET")
    @ApiImplicitParam(name = "batchNumber",value = "充值卡批次号",dataType = "string",required = true)
    @GetMapping(value = "/exportCard")
    public R<Boolean> exportCard(String batchNumber, HttpServletResponse response){
        log.info("RefillCardController[].exportCard[].input.param:batchNumber"+batchNumber);

        return refillCardService.createExcel(batchNumber,response);
    }
}
