package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.expection.BaseException;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.SchemeInfo;
import cn.wisenergy.model.vo.SchemeQueryVo;
import cn.wisenergy.model.vo.SchemeVo;
import cn.wisenergy.model.vo.VolunteerVo;
import cn.wisenergy.service.app.SchemeService;
import cn.wisenergy.service.app.VolunteerService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author 86187
 * @ Description: PC-方案
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-方案")
@RequestMapping("/scheme")
@Slf4j
public class SchemeController {

    @Autowired
    private SchemeService schemeService;

    @Autowired
    private VolunteerService volunteerService;

    @ApiOperation(value = "方案查询", notes = "方案查询", httpMethod = "GET")
    @ApiImplicitParam(name = "queryVo", value = "志愿查询参数", dataType = "SchemeQueryVo")
    @GetMapping("/getList")
    public R<VolunteerVo> getList(SchemeVo queryVo) {
        log.info("volunteer-service[]SchemeController[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参为空!");
        }

        return schemeService.getList(queryVo);
    }

    @ApiOperation(value = "Excel批量添加方案志愿", notes = "Excel批量添加方案志愿")
    @PostMapping("/excel/add")
    public R excelAdd(@RequestParam("file") MultipartFile file, @RequestParam("type") Integer type,
                      @RequestParam("schemeName") String schemeName,
                      @RequestParam("fileUrl") String fileUrl, HttpServletResponse response) throws IOException {
        log.info("volunteer-service[]SchemeController[]excelAdd[]input.param.file:" + file);
        if (file == null || file.isEmpty() || null == type || StringUtils.isBlank(schemeName) ||
                StringUtils.isBlank(fileUrl)) {
            throw new BaseException("操作错误");
        }

        volunteerService.excelAdd(file, type, schemeName, fileUrl, response);
        return R.ok("添加成功");
    }

    @ApiOperation(value = "测试Excel", notes = "测试Excel")
    @ApiImplicitParam(name = "file", value = "志愿查询参数", dataType = "MultipartFile")
    @PostMapping("/excel/add/ceshi")
    public R ceshi(@RequestBody MultipartFile file, HttpServletResponse response) throws IOException {
        log.info("");
        if (file == null || file.isEmpty()) {
            throw new BaseException("操作错误");
        }

        volunteerService.ceshi(file, response);
        return R.ok("添加成功");
    }


    @ApiOperation(value = "方案上传Excel模板", notes = "方案上传Excel模板")
    @PostMapping("/excel/template")
    public R excelTemplate(HttpServletResponse response) throws IOException {

        volunteerService.excelTemplate(response);
        return R.ok(response);
    }

    @ApiOperation(value = "获取方案列表", notes = "获取方案列表", httpMethod = "GET")
    @ApiImplicitParam(name = "queryVo", value = "查询参数", dataType = "SchemeQueryVo")
    @GetMapping("/getSchemeList")
    public R<PageInfo<SchemeInfo>> getSchemeList(SchemeQueryVo queryVo) {
        log.info("volunteer-service[]SchemeController[]getSchemeList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参为空!");
        }

        return schemeService.getSchemeList(queryVo);
    }

    @ApiOperation(value = "删除方案", notes = "删除方案", httpMethod = "DELETE")
    @ApiImplicitParam(name = "schemeId", value = "方案id", dataType = "schemeId")
    @DeleteMapping("/delete")
    public R<Boolean> delete(Integer schemeId) {
        log.info("volunteer-service[]SchemeController[]getSchemeList[]input.param.schemeId:" + schemeId);
        if (null == schemeId) {
            return R.error("入参为空!");
        }

        return schemeService.deleteById(schemeId);
    }

    @ApiOperation(value = "获取方案下载路径", notes = "获取方案下载路径", httpMethod = "GET")
    @ApiImplicitParam(name = "schemeId", value = "方案id", dataType = "int")
    @GetMapping("/download")
    public R<String> download(Integer schemeId) {
        log.info("volunteer-service[]SchemeController[]download[]input.param.schemeId:" + schemeId);
        if (null == schemeId) {
            return R.error("入参为空!");
        }

        return schemeService.download(schemeId);
    }

    @ApiOperation(value = "测试重复数据", notes = "测试重复数据", httpMethod = "GET")
    @ApiImplicitParam(name = "schemeId", value = "方案id", dataType = "int")
    @GetMapping("/ceishi")
    public List<Integer> ceishi(Integer schemeId) {

        return schemeService.ceishi(schemeId);
    }

}
