package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.SendSmsVo;
import cn.wisenergy.service.app.SendSmsSerVice;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author 86187
 * @ Description: 短信管理
 * @ Author     : 86187
 * @ Date       : 2021/1/15 15:40
 */
@RestController
@Api(tags = "短信管理")
@RequestMapping("/user")
@Slf4j
public class SendSmsController {
    @Autowired
    private SendSmsSerVice sendSmsSerVice;

    @ApiOperation(value = "发送短信验证码", notes = "发送短信验证码", httpMethod = "POST")
    @ApiImplicitParam(name = "sendSmsVo", value = "手机号码", dataType = "SendSmsVo")
    @PostMapping("/sendSms")
    public R<Boolean> sendSms(@RequestBody SendSmsVo sendSmsVo) throws Exception {
        log.info("SendSmsController[]sendSms[]input.param.sendSmsVo:" + sendSmsVo);
        if (null == sendSmsVo || StringUtils.isBlank(sendSmsVo.getPhone()) ||
                null == sendSmsVo.getSource() || null == sendSmsVo.getScene()) {
            return R.error("入参为空!");
        }

        return sendSmsSerVice.sendSmCode(sendSmsVo);
    }

    @ApiOperation(value = "在缓存中记录验证码", notes = "在缓存中记录验证码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "phone", value = "手机号码", dataType = "String", required = true),
            @ApiImplicitParam(name = "code", value = "短信验证码", dataType = "String", required = true),
            @ApiImplicitParam(name = "scene", value = "场景类型 1:验证码登录 2:手机注册 3:修改密码 4：找回密码", dataType = "int", required = true),
            @ApiImplicitParam(name = "source", value = "来源 PC/APP", dataType = "String", required = true)
    })
    @GetMapping("/valid")
    public R<Boolean> valid(String phone, String code, Integer scene, String source) {
        log.info("SendSmsController[]valid[]input.param:phone,code,type" + phone, code, scene);
        if (StringUtils.isBlank(phone) || StringUtils.isBlank(code) || StringUtils.isBlank(source) ||
                null == scene) {
            return R.error("入参为空!");
        }

        return sendSmsSerVice.valid(phone, code, scene, source);
    }
}
