package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.StaffDto;
import cn.wisenergy.model.vo.QueryVo;
import cn.wisenergy.model.vo.StaffVo;
import cn.wisenergy.service.app.StaffService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@Api(tags = "员工管理")
@RequestMapping("/staff")
@Slf4j
public class StaffController {

    @Autowired
    private StaffService staffService;

    @ApiOperation(value = "添加员工信息",notes = "添加员工信息",httpMethod = "POST")
    @ApiImplicitParam(name = "staff",value = "员工信息",dataType = "StaffVo")
    @PostMapping("/add")
    public R<Boolean> addStaff(@RequestBody StaffVo staff){
        log.info("StaffController[].addStaff[].input.param:"+staff);

        return staffService.addStaff(staff);
    }

    @ApiOperation(value = "编辑员工信息",notes = "编辑员工信息",httpMethod = "POST")
    @ApiImplicitParam(name = "staff",value = "员工信息",dataType = "StaffVo")
    @PostMapping("/edit")
    public R<Boolean> editStaff(@RequestBody StaffVo staff){
        log.info("StaffController[].editStaff[].input.param:"+staff);

        return staffService.editStaff(staff);
    }

    @ApiOperation(value = "获取员工信息列表",notes = "获取员工信息列表",httpMethod = "POST")
    @ApiImplicitParam(name = "queryVo",value = "员工信息",dataType = "QueryVo")
    @PostMapping("/getList")
    public R<PageInfo<StaffDto>> getStaffList(@RequestBody QueryVo queryVo){
        log.info("StaffController[].getStaffList[].input.param:"+queryVo);

        return staffService.getStaffList(queryVo);
    }

    @ApiOperation(value = "禁用员工登录",notes = "禁用员工登录",httpMethod = "GET")
    @ApiImplicitParam(name = "staffId",value = "员工id",dataType = "int")
    @GetMapping("/delete")
    public R<Boolean> delete(Integer staffId){
        log.info("StaffController[].delete[].input.param:"+staffId);

        return staffService.delete(staffId);
    }

}
