package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Local;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.*;
import cn.wisenergy.service.app.SchemeService;
import cn.wisenergy.service.app.StaffUserVipService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@RestController
@Api(tags = "员工端")
@RequestMapping("/staffUser")
@Slf4j
public class StaffUserVipController {
    @Autowired
    private StaffUserVipService staffUserVipService;

    @Autowired
    private SchemeService schemeService;

    @ApiOperation(value = "员工登录",notes = "员工登录",httpMethod = "POST")
    @ApiModelProperty(name = "loginVo",value = "登录信息",dataType = "AccountLoginVo")
    @PostMapping("/login")
    public R<Boolean> login(@RequestBody AccountLoginVo loginVo){
        log.info("StaffUserVipController[].login[].input.param:"+loginVo);

        return staffUserVipService.staffLogin(loginVo);
    }

    @ApiOperation(value = "添加Vip客户(当客户已存在时)",notes = "添加Vip客户(当客户已存在时)",httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "staffId", value = "员工id", dataType = "int"),
            @ApiImplicitParam(name = "phone", value = "vip客户手机号", dataType = "string")
    }
    )
    @PostMapping("/add2")
    public R<Boolean> addUserVipByPhone(Integer staffId, String phone){
        log.info("StaffUserVipController[].addUserVipByPhone[].input.param:"+staffId,phone);

        return staffUserVipService.addUserByPhone(staffId,phone);
    }

    @ApiOperation(value = "查询Vip客户",notes = "查询Vip客户",httpMethod = "POST")
    @ApiModelProperty(name = "queryVo",value = "vip客户信息",dataType = "UserVipQueryVo")
    @PostMapping("/getList")
    public R<PageInfo<UserInfoDto>> getUserVipList(@RequestBody UserVipQueryVo queryVo){
        log.info("StaffUserVipController[].addUserVip[].input.param:"+queryVo);

        return staffUserVipService.getList(queryVo);
    }

    @ApiOperation(value = "查询地区",notes = "查询地区",httpMethod = "GET")
    @GetMapping("/getLocal")
    public R<List<Local>> getLocal(){
        log.info("StaffUserVipController[].addUserVip[].input.param:");

        return staffUserVipService.getLocal();
    }

    @ApiOperation(value = "vip客户方案查询", notes = "vip客户方案查询", httpMethod = "GET")
    @ApiImplicitParam(name = "queryVo", value = "志愿查询参数", dataType = "SchemeVipVo")
    @GetMapping("/getList")
    public R<VolunteerVo> getList(SchemeVipVo queryVo) {
        log.info("volunteer-service[]SchemeController[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参为空!");
        }

        return schemeService.getListVip(queryVo);
    }

    @ApiOperation(value = "vip客户方案保存", notes = "vip客户方案保存", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "志愿ids,如'1,2,3,4,5,6...", dataType = "string"),
            @ApiImplicitParam(name = "userId", value = "vip客户id", dataType = "int"),
            @ApiImplicitParam(name = "name", value = "所选专业名称", dataType = "string"),
    }
    )
    @GetMapping("/addUserVoluteer")
    public R<Boolean> addUserVoluteer(String ids,Integer userId,String name) {
        log.info("volunteer-service[]addUserVoluteer[]getList[]input.param.queryVo:" + ids,userId,name);

        return staffUserVipService.addUserVolunteer(ids,userId,name);
    }

    @ApiOperation(value = "VIP客户信息Excel导出",notes = "VIP客户信息Excel导出",httpMethod = "POST")
    @ApiModelProperty(name = "queryVo",value = "vip客户信息",dataType = "UserVipQueryVo")
    @PostMapping("/downExcel")
    public R<Boolean> downExcel(@RequestBody UserVipQueryVo queryVo, HttpServletResponse response){
        log.info("StaffUserVipController[].downExcel[].input.param:"+queryVo);

        return staffUserVipService.downExcel(queryVo,response);
    }
}
