package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.service.util.SubCodeUtil;
import cn.wisenergy.service.wxpay.WxCommon;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 86187
 */
@Api(tags = "测试微信支付-管理员登录")
@RestController
@RequestMapping("/pay")
@Slf4j
public class TestWxPayController {

    /**
     * 产生订单接口
     *
     * @param payType 支付类型
     * @param id      支付信息id
     * @return
     * @throws WxPayException
     */
    @RequestMapping(value = "/generatePay/{payType}/{id}", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "微信统一下单接口1")
    public R generatePay2(@ApiParam(required = true) @PathVariable(value = "payType") String payType,
                          @ApiParam(required = true) @PathVariable(value = "id") String id) throws WxPayException {
        String tradeNo = SubCodeUtil.getNum();
        String busId = "123131313";
        Integer fee = 1;
        WxPayUnifiedOrderRequest.WxPayUnifiedOrderRequestBuilder builder = WxPayUnifiedOrderRequest.newBuilder();
        WxPayUnifiedOrderRequest request = builder.body(payType)
                .totalFee(fee).outTradeNo(tradeNo)
                .productId("1000000123")
                .spbillCreateIp("0.0.0.0")
                .tradeType("NATIVE").build();
        request.setSignType("MD5");
        WxPayService wxPayService = getWxPayService();
        WxPayNativeOrderResult o = wxPayService.createOrder(request);
        System.out.println(o.toString());
        return R.ok(o);
    }

    /**
     * 接收支付返回的消息
     *
     * @param
     */
    @RequestMapping(value = "/parseOrderNotifyResult", method = RequestMethod.POST)
    @ApiOperation(value = "接收支付返回的消息")
    @ResponseBody
    public String parseOrderNotifyResult(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("============支付回调开始");
        try {
            String xmlResult = IOUtils.toString(request.getInputStream(), request.getCharacterEncoding());
            WxPayService wxPayService = getWxPayService();
            WxPayOrderNotifyResult result = wxPayService.parseOrderNotifyResult(xmlResult);
            System.out.println(result.toString());
            // 结果正确
            String orderId = result.getOutTradeNo();
            String tradeNo = result.getTransactionId();
            //String totalFee = WxPayBaseResult.feeToYuan(result.getTotalFee());
            //自己处理订单的业务逻辑，需要判断订单是否已经支付过，否则可能会重复调用
            System.out.println("============支付回调结束");
            return WxPayNotifyResponse.success("处理成功!");
        } catch (Exception e) {
            log.error("微信回调结果异常,异常原因{}" + e.getMessage());
            return WxPayNotifyResponse.fail(e.getMessage());
        }
    }

    /**
     * 加载配置文件，生成微信payservice对象
     *
     * @return
     */
    private WxPayService getWxPayService() {
        WxPayConfig payConfig = new WxPayConfig();

        String app_id = "wx39c84a7da8e71c32";
        String mchid = "1605798036";
        String private_key = "yHG21lRpqil1X3fWG0VFytxFuXzxIpRd";

//        payConfig.setAppId(WxCommon.APP_ID);
//        payConfig.setMchId(WxCommon.MCHID);
//        payConfig.setMchKey(WxCommon.PRIVATE_KEY);
        payConfig.setAppId(app_id);
        payConfig.setMchId(mchid);
        payConfig.setMchKey(private_key);
        payConfig.setNotifyUrl(WxCommon.NOTIFY_URL);
        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }
}
