package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.UserLimit;
import cn.wisenergy.model.vo.AddLimitVo;
import cn.wisenergy.model.vo.MinusLimitVo;
import cn.wisenergy.service.app.UserLimitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author 86187
 * @ Description: PC-用户查询次数
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-用户查询次数")
@RequestMapping("/user/limit")
@Slf4j
public class UserLimitController {

    @Autowired
    private UserLimitService userLimitService;

    @ApiOperation(value = "获取用户查询次数", notes = "获取用户查询次数", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "int", required = true)
    @GetMapping("/getByUserId")
    public R<UserLimit> getByUserId(Integer userId) {
        log.info("volunteer-service[]UserLimitController[]getVolunteerList[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参为空!");
        }

        return userLimitService.getByUserId(userId);
    }

    @ApiOperation(value = "用户充值", notes = "用户充值", httpMethod = "POST")
    @ApiImplicitParam(name = "addLimitVo", value = "充值信息", dataType = "AddLimitVo")
    @PostMapping("/addLimit")
    public R<Boolean> addLimit(@RequestBody AddLimitVo addLimitVo) {
        log.info("volunteer-service[]UserLimitController[]addLimit[]input.param.addLimitVo:" + addLimitVo);
        if (null == addLimitVo || null == addLimitVo.getUserId() || null == addLimitVo.getPayType()) {
            return R.error("入参不能为空!");
        }

        return userLimitService.addLimit(addLimitVo);
    }


    @ApiOperation(value = "扣减用户查询次数", notes = "扣减用户查询次数", httpMethod = "POST")
    @ApiImplicitParam(name = "minusLimitVo", value = "用户id", dataType = "MinusLimitVo")
    @PostMapping("/minusLimit")
    public R<Boolean> minusLimit(@RequestBody MinusLimitVo minusLimitVo) {
        log.info("volunteer-service[]UserLimitController[]minusLimit[]input.param.minusLimitVo:" + minusLimitVo);
        if (null == minusLimitVo || null == minusLimitVo.getUserId()) {
            return R.error("入参为空!");
        }

        return userLimitService.minusLimit(minusLimitVo.getUserId());
    }


}
