package cn.wisenergy.mapper;

import cn.wisenergy.model.app.Banner;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface BannerMapper extends BaseMapper<Banner> {
    /**
     * 添加广告
     *
     * @param advertising 广告信息
     * @return 广告信息
     */
    Banner add(Banner advertising);

    /**
     * 编辑广告
     *
     * @param advertising 广告信息
     * @return 结果
     */
    int edit(Banner advertising);

    /**
     * 删除广告
     *
     * @param id 广告id
     * @return 结果
     */
    int delById(@Param("id") Integer id);

    /**
     * 获取广告列表
     * @param map 筛选参数
     * @return 广告列表
     */
    List<Banner> getList(@Param("map") Map<String,Object> map);

    /**
     * 统计广告条数
     * @return  广告条数
     */
    int count();
}
