package cn.wisenergy.mapper;

import cn.wisenergy.model.app.SchemeQueryRecord;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author 86187
 */
public interface SchemeRecordMapper extends BaseMapper<SchemeQueryRecord> {

    /**
     * 添加方案记录
     * @param schemeQueryRecord 方案记录信息
     * @return 方案记录信息
     */
    SchemeQueryRecord add(SchemeQueryRecord schemeQueryRecord);

    /**
     * 编辑方案记录
     * @param schemeQueryRecord 方案记录信息
     * @return 0 失败  1 成功
     */
    int edit(SchemeQueryRecord schemeQueryRecord);

    /**
     * 获取方案记录信息
     * @param id 方案记录id
     * @return
     */
    int delById(@Param("id") Integer id);

    /**
     *  统计方案记录条数
     * @param map 统计条件
     * @return 记录条数
     */
    int count(@Param("map") Map<String, Object> map);

    List<SchemeQueryRecord> getList(@Param("map") Map<String, Object> map);
}
