package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "SchemeInnfo")
public class SchemeInfo extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 7020644673356401949L;
    /**
     * 方案id
     */
    @ApiModelProperty(value = "方案id", name = "id")
    private Integer id;

    /**
     * 方案名称
     */
    @ApiModelProperty(value = "方案名称", name = "schemeName")
    private String schemeName;

    /**
     * 上传时间
     */
    @ApiModelProperty(value = "上传时间", name = "uploadTime")
    private Date uploadTime;

    /**
     * 1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导
     * 4：本科体育  5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批
     */
    @ApiModelProperty(value = "1：本科文化一批 2：本科美术一批 3：文学编导本科一批 4：本科体育  " +
            "5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批", name = "type")
    private Integer type;

}
