package cn.wisenergy.model.app;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @ Description: 志愿实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/7 15:15
 */
@Data
@Builder
@ApiModel(value = "Volunteer")
@NoArgsConstructor
@AllArgsConstructor
@ExcelIgnoreUnannotated
public class Volunteer implements Serializable {
    private static final long serialVersionUID = -7880251929353475087L;

    /**
     * 志愿主键id
     */
    @ApiModelProperty(value = "志愿主键id", name = "id")
    private Integer id;

    /**
     * 专业名称
     */
    @ApiModelProperty(value = "专业名称", name = "majorName")
    @ExcelProperty(value = "姓名")
    private String majorName;

    /**
     * 院校
     */
    @ApiModelProperty(value = "院校", name = "academy")
    @ExcelProperty(value = "姓名")
    private String academy;

    /**
     * 选考科目要求
     */
    @ApiModelProperty(value = "选考科目要求", name = "courseDemand")
    @ExcelProperty(value = "姓名")
    private String courseDemand;

    /**
     * 学校性质
     */
    @ApiModelProperty(value = "学校性质", name = "nature")
    @ExcelProperty(value = "姓名")
    private String nature;

    /**
     * 学年制（年）
     */
    @ApiModelProperty(value = "学年制（年）", name = "yearLimit")
    @ExcelProperty(value = "姓名")
    private Integer yearLimit;

    /**
     * 计划数
     */
    @ApiModelProperty(value = "计划数", name = "planNum")
    @ExcelProperty(value = "姓名")
    private Integer planNum;

    /**
     * 计划投档数
     */
    @ApiModelProperty(value = "计划投档数", name = "castArchivesNum")
    @ExcelProperty(value = "姓名")
    private Integer castArchivesNum;

    /**
     * 投出数
     */
    @ApiModelProperty(value = "投出数", name = "launchNum")
    @ExcelProperty(value = "姓名")
    private Integer launchNum;

    /**
     * 最低分
     */
    @ApiModelProperty(value = "最低分", name = "lowestMark")
    @ExcelProperty(value = "姓名")
    private String lowestMark;

    /**
     * 最低位次
     */
    @ApiModelProperty(value = "最低位次", name = "lowestRank")
    @ExcelProperty(value = "姓名")
    private String lowestRank;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", name = "updateTime")
    private Date updateTime;
}
