package cn.wisenergy.model.dto;

import cn.wisenergy.model.app.ScoreInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ Description: 用户列表展示dto
 * @ Author     : 86187
 * @ Date       : 2021/1/7 10:47
 */
@Data
@ApiModel(value = "UserInfoDto")
public class UserInfoDto implements Serializable {

    private static final long serialVersionUID = 4791446858538524520L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    private String userName;

    /**
     * 性别 0：男 1：女
     */
    @ApiModelProperty(value = "性别 0：男 1：女", name = "sex")
    private Integer sex;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "studentType")
    private Integer studentType;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机号", name = "phone")
    private String phone;

    /**
     * 文化成绩
     */
    @ApiModelProperty(value = "文化成绩", name = "cultureGrade")
    private String cultureGrade;

    /**
     * 专业成绩
     */
    @ApiModelProperty(value = "专业成绩", name = "majorGrade")
    private String majorGrade;

    /**
     * 用户剩余查询次数
     */
    @ApiModelProperty(value = "用户剩余查询次数", name = "queryLimit")
    private Integer queryLimit;

    /**
     * 用户充值总金额
     */
    @ApiModelProperty(value = "用户充值总金额", name = "moneyAmount")
    private String moneyAmount;

    /**
     * ip
     */
    @ApiModelProperty(value = "ip", name = "ip")
    private String ip;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间", name = "registerTime")
    private Date registerTime;

    /**
     * 用户最后登陆时间
     */
    @ApiModelProperty(value = "用户最后登陆时间", name = "lastLoginTime")
    private Date lastLoginTime;




}
