package cn.wisenergy.model.vo;

import cn.wisenergy.model.app.ScoreInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
*@ Description: 用户对外展示信息Vo
*@ Author     : 86187
*@ Date       : 2021/1/12 15:29
*/
@Data
@ApiModel(value = "UserShowVo")
public class UserShowVo implements Serializable {
    private static final long serialVersionUID = 2451826421351862268L;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id",name = "id")
    private Integer id;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称",name = "userName")
    private String userName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别",name = "sex")
    private Integer sex;

    /**
     * 毕业高中学校
     */
    @ApiModelProperty(value = "毕业高中学校",name = "school")
    private String school;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生",name = "studentType")
    private Integer studentType;

    /**
     * 学生成绩信息
     */
    @ApiModelProperty(value = "学生成绩信息",name = "scoreInfo")
    private ScoreInfo scoreInfo;
}
