package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.AccountMapper;
import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.model.dto.AccountDto;
import cn.wisenergy.service.app.AccountSerivce;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;

@Slf4j
@Service
public class AccountSerivceImpl implements AccountSerivce {

    @Autowired
    private AccountMapper accountMapper;

    @Override
    public R<AccountDto> getAccountInfo(String userName, String password) {
        log.info("AccountSerivceImpl[].getAccountInfo[].input.param:userName,password"+userName,password);
        //创建参数容器map
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("userName",userName);

        //查询管理者信息
        AccountInfo accountInfo = accountMapper.getAccountInfo(map);
        if (null==accountInfo) {
            return R.error("用户不存在");
        }

        //将加密过后的密码与传输数据进行比较
        String s = Md5Util.digestMD5(accountInfo.getPassword());
        if (!password.equals(s)) {
            return R.error("密码或者用户名错误");
        }

        //查询超过则进行数据copy
        AccountDto accountDto = new AccountDto();
        BeanUtils.copyProperties(accountInfo,accountDto);
        //返回数据
        return R.ok(accountDto);
    }
}
