package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.ProfessionMapper;
import cn.wisenergy.model.app.Profession;
import cn.wisenergy.service.app.ProfessionService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @ Description: 专业接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/13 10:52
 */
@Service
@Slf4j
public class ProfessionServiceImpl extends ServiceImpl<ProfessionMapper, Profession> implements ProfessionService {

    @Autowired
    private ProfessionMapper professionMapper;

    @Override
    public R<List<Profession>> getTree() {
        log.info("volunteer-service[]ProfessionServiceImpl[]getTree[]input.method");

        //获取所有专业
        List<Profession> rootList = professionMapper.getList();

        //构造树形接口：递归
        List<Profession> streetList = getStreetList(rootList);

        return R.ok(streetList);
    }

    private List<Profession> getStreetList(List<Profession> list) {
        List<Profession> rootList = new ArrayList<>();
        List<Profession> childrenList = new ArrayList<>();

        //1|遍历出根节点和子节点
        for (Profession profession : list) {
            if (profession.getLevel() == 1) {
                rootList.add(profession);
            } else {
                childrenList.add(profession);
            }
        }

        //2.遍历集合，获取根节点下的子节点
        for (Profession profession : rootList) {
            List<Profession> children = setChildren(profession.getId(), childrenList);
            profession.setChildren(children);
        }
        return rootList;
    }

    private List<Profession> setChildren(Integer id, List<Profession> list) {
        List<Profession> children = new ArrayList<>();
        for (Profession profession : list) {
            if (id.equals(profession.getParentId())) {
                children.add(profession);
            }
        }

        for (int i = 0; i < children.size(); i++) {
            Integer autoId = children.get(i).getId();
            List<Profession> childrenList = setChildren(autoId, list);
            children.get(i).setChildren(childrenList);
        }
        return children;
    }
}
