package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.vo.SchemeQueryVo;
import cn.wisenergy.model.vo.VolunteerVo;
import cn.wisenergy.service.app.SchemeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ Description: 方案接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/13 15:04
 * @author 86187
 */
@Service
@Slf4j
public class SchemeServiceImpl extends ServiceImpl<SchemeMapper, SchemeInfo> implements SchemeService {
    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private ScoreInfoMapper scoreInfoMapper;

    @Autowired
    private VolunteerMapper volunteerMapper;

    @Autowired
    private SchemeRecordMapper schemeRecordMapper;

    @Autowired
    private UserVolunteerMapper userVolunteerMapper;

    @Override
    public R<VolunteerVo> getList(SchemeQueryVo queryVo) {
        log.info("volunteer-service[]SchemeServiceImpl[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo || null == queryVo.getUserId()) {
            return R.error("入参为空!");
        }

        //1、根据userId获取用户信息
        UserInfo userInfo = usersMapper.selectById(queryVo.getUserId());
        if (null == userInfo) {
            return R.error("用户信息不存在!");
        }

        //2、根据筛选方案算法，筛选方案
        Map<String, Object> map = new HashMap<>(16);

        List<Volunteer> list = volunteerMapper.getList(map);
        if (CollectionUtils.isEmpty(list)) {
            return R.ok(new VolunteerVo());
        }
        //3、保存方案查询记录
        SchemeQueryRecord schemeQueryRecord = new SchemeQueryRecord();
        schemeQueryRecord.setMajorName("");
        schemeQueryRecord.setStudentType(userInfo.getExamType());
        schemeQueryRecord.setUserId(userInfo.getId());
        schemeQueryRecord.setIsDelete(0);
        double score = Double.parseDouble(queryVo.getCultureGrade()) + Double.parseDouble(queryVo.getMajorGrade());
        schemeQueryRecord.setScore(String.valueOf(score));

        //保存用户方案记录、志愿之间的关联关系
        List<Integer> ids = list.stream().map(Volunteer::getId).collect(Collectors.toList());
        boolean bool = saveUserVolunteer(userInfo.getId(), ids, schemeQueryRecord);
        if (!bool) {
            return R.error("保存方案查询记录失败!");
        }

        VolunteerVo volunteerVo = new VolunteerVo();
        volunteerVo.setUserId(userInfo.getId());
        volunteerVo.setVolunteers(list);
        return R.ok(volunteerVo);
    }


    /**
     * 保存方案查询记录和关联关系
     *
     * @param userId            用户id
     * @param ids               志愿ids
     * @param schemeQueryRecord 方案记录
     * @return true 成功  false 失败
     */
    @Transactional
    public boolean saveUserVolunteer(Integer userId, List<Integer> ids, SchemeQueryRecord schemeQueryRecord) {
        //保存方案查询记录
        SchemeQueryRecord count = schemeRecordMapper.add(schemeQueryRecord);
        if (null == count) {
            return false;
        }

        List<UserVolunteer> volunteerList = new ArrayList<>();
        for (Integer id : ids) {
            UserVolunteer userVolunteer = new UserVolunteer();
            userVolunteer.setSchemeRecordId(count.getId());
            userVolunteer.setUserId(userId);
            userVolunteer.setVolunteerId(id);
            volunteerList.add(userVolunteer);
        }

        int save = userVolunteerMapper.creates(volunteerList);
        if (volunteerList.size() != save) {
            return false;
        }
        return true;
    }
}
