// 内容管理
const videoCopyrightAdd = r => require.ensure([], () => r(require('@/page/content/video/copyright/add')), 'videoCopyrightAdd');
const videoCopyrightUpdate = r => require.ensure([], () => r(require('@/page/content/video/copyright/add')), 'videoCopyrightUpdate');

const videoContentAdd = r => require.ensure([], () => r(require('@/page/content/video/content/add')), 'videoContentAdd');
const videoContentUpdate = r => require.ensure([], () => r(require('@/page/content/video/content/add')), 'videoContentUpdate');
export let learnRoute = [
    {
        path: '/videoCopyrightAdd',
        name: '新建版权方',
        component: videoCopyrightAdd,
        meta: {
            showBreadcrumb: true,
            title: '新建版权方',
        }
    },
    {
        path: '/videoCopyrightUpdate',
        name: '修改版权方',
        component: videoCopyrightUpdate,
        meta: {
            showBreadcrumb: true,
            title: '修改版权方',
        }
    },
    {
        path: '/videoContentAdd',
        name: '新建视频',
        component: videoContentAdd,
        meta: {
            showBreadcrumb: true,
            title: '新建视频',
        }
    },
    {
        path: '/videoContentUpdate',
        name: '修改视频',
        component: videoContentUpdate,
        meta: {
            showBreadcrumb: true,
            title: '修改视频',
        }
    },
    {
        path: '/videoCopyright',
        name: '视频版权方管理',
        component: () => import('@/page/content/video/copyright/index'),
        meta: {
            showBreadcrumb: true,
            title: '视频版权方管理',
        }
    },
    {
        path: '/videoClassify',
        name: '视频分类管理',
        component: () => import('@/page/content/video/classify/index'),
        meta: {
            showBreadcrumb: true,
            title: '视频分类管理',
        }
    },
    {
        path: '/videoContent',
        name: '视频内容管理',
        component: () => import('@/page/content/video/content/index'),
        meta: {
            showBreadcrumb: true,
            title: '视频内容管理',
        }
    },
    {
        path: '/videoRemit',
        name: '视频汇出',
        component: () => import('@/page/content/video/remit/index'),
        meta: {
            showBreadcrumb: true,
            title: '视频汇出',
        }
    },
    // --- 展板
    {
        path: '/displayCopyright',
        name: '展板版权方管理',
        component: () => import('@/page/content/display/copyright/index'),
        meta: {
            showBreadcrumb: true,
            title: '展板版权方管理',
        }
    },
    {
        path: '/displayCopyrightAdd',
        name: '新建展板版权方',
        component: () => import('@/page/content/display/copyright/add'),
        meta: {
            showBreadcrumb: true,
            title: '新建展板版权方',
        }
    },
    {
        path: '/displayCopyrightUpdate',
        name: '修改展板版权方',
        component: () => import('@/page/content/display/copyright/add'),
        meta: {
            showBreadcrumb: true,
            title: '修改展板版权方',
        }
    },
    {
        path: '/displayClassify',
        name: '展板分类管理',
        component: () => import('@/page/content/display/classify/index'),
        meta: {
            showBreadcrumb: true,
            title: '展板分类管理',
        }
    },
    {
        path: '/displayContent',
        name: '展板内容管理',
        component: () => import('@/page/content/display/content/index'),
        meta: {
            showBreadcrumb: true,
            title: '展板内容管理',
        }
    },
    {
        path: '/displayContentAdd',
        name: '新建展板',
        component: () => import('@/page/content/display/content/add'),
        meta: {
            showBreadcrumb: true,
            title: '新建展板',
        }
    },
    {
        path: '/displayContentUpdate',
        name: '修改展板',
        component: () => import('@/page/content/display/content/add'),
        meta: {
            showBreadcrumb: true,
            title: '修改展板',
        }
    },
    {
        path: '/displayContentDetails',
        name: '展板管理详情',
        component: () => import('@/page/content/display/content/details'),
        meta: {
            showBreadcrumb: true,
            title: '展板管理详情',
        }
    },
    // --学习
    {
        path: '/learnProject',
        name: '学习项目管理',
        component: () => import('@/page/content/learn/project/index'),
        meta: {
            showBreadcrumb: true,
            title: '学习项目管理',
        }
    },
    {
        path: '/learnContent',
        name: '学习内容制作',
        component: () => import('@/page/content/learn/content/index'),
        meta: {
            showBreadcrumb: true,
            title: '学习内容制作',
        }
    },
    {
        path: '/learnContentAdd',
        name: '新建学习内容',
        component: () => import('@/page/content/learn/content/add'),
        meta: {
            showBreadcrumb: true,
            title: '新建学习内容',
        }
    },
    {
        path: '/learnContentUpdate',
        name: '修改学习内容',
        component: () => import('@/page/content/learn/content/add'),
        meta: {
            showBreadcrumb: true,
            title: '修改学习内容',
        }
    },
    {
        path: '/learnContentDetails',
        name: '学习内容详情',
        component: () => import('@/page/content/learn/content/details'),
        meta: {
            showBreadcrumb: true,
            title: '学习内容详情',
        }
    },

    // 审核
    {
        path: '/checkVideo',
        name: '视频审核',
        component: () => import('@/page/check/video/index'),
        meta: {
            showBreadcrumb: true,
            title: '视频审核',
        }
    },
    {
        path: '/checkDisplay',
        name: '展板审核',
        component: () => import('@/page/check/display/index'),
        meta: {
            showBreadcrumb: true,
            title: '展板审核',
        }
    },
    {
        path: '/checkLearn',
        name: '平台学习内容审核',
        component: () => import('@/page/check/learn/index'),
        meta: {
            showBreadcrumb: true,
            title: '平台学习内容审核',
        }
    },
    {
        path: '/checkLearnDetails',
        name: '学习内容详情',
        component: () => import('@/page/check/learn/details'),
        meta: {
            showBreadcrumb: true,
            title: '学习内容详情',
        }
    }
]
