/**
 * Created by cp on 2016/11/22.
 */


import Style from 'ol/style/Style';
import Icon from 'ol/style/Icon';
import Fill from 'ol/style/Fill';
import Stroke from 'ol/style/Stroke';
import Circle from 'ol/style/Circle';


import SnapGuides from 'ol-ext/interaction/SnapGuides';

import Collection from 'ol/Collection';
import {Tile as TileLayer, Vector as VectorLayer} from 'ol/layer';
import {OSM, Vector as VectorSource} from 'ol/source';
import Modify from 'ol/interaction/Modify';
import Draw, {createRegularPolygon, createBox} from 'ol/interaction/Draw';
import CircleStyle from 'ol/style/Circle';

//有一些类对外放出的不是一个对象，二是一个个的方法如
// import condition from 'ol/events/condition'; 错误的引用
import {click, pointerMove, altKeyOnly,shiftKeyOnly,singleClick} from 'ol/events/condition';//正确的引用

// var source = new VectorSource({wrapX: false});

function startDraw(mainMap,vueThis){
  let map=mainMap.getMap();
  let ol=mainMap.ol;
  var tempObj={};



  var drawFeatures = new Collection();
  var featureOverlay = new VectorLayer({
    source: new VectorSource({features: drawFeatures})
  });
  featureOverlay.setMap(map);
  var modifyFeatures = new Collection();
  //编辑
  var modify = new Modify({
    features: modifyFeatures,
    deleteCondition: function(event) {
      return  shiftKeyOnly(event) &&
        singleClick(event);
    }
  });
  map.addInteraction(modify);




  function setEditFeature(fes){

    modifyFeatures.clear();
    // for(var i=0;i<fes.length;i++){
    var tempf= fes;
    var oldstyle=tempf.getStyle();
    tempf.set("oldStyle",oldstyle);
    var oldGeom=tempf.getGeometry().clone();
    tempf.set("oldGeom",oldGeom);
    modifyFeatures.push(tempf);
    // }
  }



  tempObj.setEditFeature=setEditFeature;

  function remoAllEditDraw(calFunc,okFunc){
    var drarr=drawFeatures.getArray();
    var modifyArr=modifyFeatures.getArray();
    if(drarr.length>0||modifyArr.length>0){

    }else{
      if(okFunc){
        okFunc();
      }
    }

  }
  tempObj.remoAllEditDraw=remoAllEditDraw;

  function  cleanModifyOrDraw(){
    clanLayer();
    cleanModifyFunc();
    removeDrawFunc();//清除上一次绘制的配置
  }
  tempObj.cleanModifyOrDraw=cleanModifyOrDraw;

  function cleanAllFeature(succ){
    showAlertW('确认清除？',null,function(){
      cleanModifyOrDraw();
      if(succ){
        succ();
      }
    })
  }
  tempObj.cleanAllFeature=cleanAllFeature;

  function showAlertW(count,calFunc,okFunc){
    //删除活动事件
    vueThis.$confirm(count, '提示', {
      confirmButtonText: '确定',
      cancelButtonText: '取消',
      type: 'warning',
    }).then(() => {
      if(okFunc){
        okFunc();

      }
    }).catch(() => {
      if(calFunc){
        calFunc();
      }
    });
  }


  function getModifyFeature(){
    if(modifyFeatures){
      return modifyFeatures.getArray() ;
    }
    return null;
  }

  tempObj.getModifyFeature=getModifyFeature;



  function  cleanModifyFunc(){
    for(var kk=0;kk<modifyFeatures.getArray().length;kk++){
      var f1=modifyFeatures.getArray()[kk];
      var olsty=f1.get("oldStyle");
      if(olsty){
        f1.setStyle(olsty);
      }
      var oldGeom = f1.get("oldGeom");
      if(oldGeom){
        f1.setGeometry(oldGeom);
      }
    }
    modifyFeatures.clear();
  }


  //停止编辑
  function remoaveEditFeature(succ){
    if(modifyFeatures&&modifyFeatures.getArray().length>0){
      showAlertW('存在未保存的编辑，确认不保存？',null,function(){
        cleanModifyFunc();
        if(succ){
          succ();
        }
      });

    }
  }
  tempObj.remoaveEditFeature=remoaveEditFeature;


  //绘制
  var draw;
  function clanLayer(){
    featureOverlay.getSource().clear();
  }
  tempObj.clanLayer=clanLayer;


  //Point,点   LineString线  Polygon 面  Square  矩形  Circle 圆  Box  盒子
  function addInteraction(type,func) {
    var drarr=drawFeatures.getArray();
    var modifyArr=modifyFeatures.getArray();
    if(drarr.length>0||modifyArr.length>0){
      //绘制的时候  现在和地图中的事件添加 有冲突  导致清除之后 地图上的还有开始绘制的东西  ，后面想办法解决一下
      showAlertW('存在未保存的编辑，确认不保存？',null,function(){
        startDrawFunc(type);
        if(func){
          func();
        }
      });
    }else{
      startDrawFunc(type);
    }
  }
  tempObj.addInteraction=addInteraction;

  let geometryFunction;
  function  startDrawFunc(type){
    removeDrawFunc();//清除上一次绘制的配置
    cleanModifyFunc();//清除修改的部分
    featureOverlay.getSource().clear();

    if(type==vueThis.SQUARE||type==vueThis.BOX){
      if(type==vueThis.SQUARE){
        geometryFunction = createRegularPolygon(4);
      }else{
        geometryFunction =  createBox();
      }
      //都是以原型的来绘制
      draw = new Draw({
        features: drawFeatures,
        type:vueThis.DRAW_CIRCLE,
        geometryFunction: geometryFunction
      });
    }else{
      let tempType="";
      if(type==vueThis.DRAW_TEXT){
        tempType=vueThis.POINT_TYPE;
      }else{
        tempType=type;
      }

      draw = new Draw({
        features: drawFeatures,
        type:tempType
      });
    }





    if(type==vueThis.POLYGON_TYPE||type==vueThis.LINE_STRING_TYPE){
      var snapi = new SnapGuides();//  {options} 参数可以进行设置
      snapi.setDrawInteraction(draw);
      map.addInteraction(snapi);
    }

    draw.on("drawend",function(event){
      var drawF=  event.feature;
      modifyFeatures.push(drawF);
      addFeatureFunc(drawF,type);
      removeDrawFunc();
    });


    map.addInteraction(draw);
  }


  function setStyleInit(data,type){
    //点
    if(type==vueThis.POINT_TYPE){
      vueThis.pointStyle=data;
    }else if(type==vueThis.LINE_STRING_TYPE){
      //线
      vueThis.lineStyle=data;
    }else{
      vueThis.polygonStyle=data;
    }
  }


  function addFeatureFunc(fe,type){
    var data={};
    data.strokeColor="#0099ff";
    data.strokeWeight=3;
    data.strokeAlpha=1
    data.fillAlpha=0.7;
    data.fillColor="#ffffff";
    data.fileRadio=7;
    data.imageSrc=null;
    data.lineDash=1;


    fe.set("featureType",type);
    setStyleInit(data,type);
    fe.on('singleclick', function(event){
      if(callFunc){
        callFunc(type,fe,event);
      }
    });
    fe.set('singleclick',true);//标识该点存在点击事件
  }

  var callFunc=null;
  function  setCilckCallBack(callFuncItem){
    callFunc=callFuncItem
  }
  tempObj.setCilckCallBack=setCilckCallBack;


  function getExistEditFeature(){
    var drarr=drawFeatures.getArray();
    var modifyArr=modifyFeatures.getArray();
    if(drarr.length>0||modifyArr.length>0){
      return true;
    }
    return false;
  }
  tempObj.getExistEditFeature=getExistEditFeature;


  //移除绘制
  function  removeDrawFunc(){
    if(draw){
      map.removeInteraction(draw);
    }

  }

  tempObj.removeDrawFunc=removeDrawFunc;

  return tempObj;
}


export {startDraw}
