
import {addProjection, addCoordinateTransforms, transform} from 'ol/proj';
import Point from 'ol/geom/Point';
import Feature from 'ol/Feature';
import {Tile as TileLayer, Vector as VectorLayer,Heatmap} from 'ol/layer';
import {OSM, Vector as VectorSource} from 'ol/source';


function  startDataClass(mainMap){
  let  obj={};
  // 设置参数
  mainMap.setMaxMinZoom(4, 18);// 设置地图的显示级别范围
  mainMap.startZoom = 0;// 设置地图的初始化显示级别
  mainMap.init('map');
  mainMap.setCenterAndZoom( [106.9370411668,27.7318344381],13); //修改地图中心点
  let map=mainMap.getMap();





  function  createFe(data){
    var n1=parseFloat(data.lon);
    var n2=parseFloat(data.lat);
    if(!n1||!n2){
      return null;
    }
    var pa1=[];
    pa1.push([n1,n2]);
    var p1;
    p1= new Point(pa1[0]);
    p1.transform('EPSG:4326', 'EPSG:900913');
    var f1= new Feature({
      geometry: p1
    });

    return f1;
  }

  let heatmap;
  function createHeatMap(data){
    var  source= new  VectorSource();
    for (let i=0;i<data.length;i++){
      let f1=createFe(data[i]);
      if(f1){
        source.addFeature(f1);
      }
    }



//热度图
    var blur = 15;
    var radius = 5;


    heatmap = new Heatmap({
      source:source,
      blur: parseInt(15, 10),
      radius: parseInt(5, 10)
    });
    heatmap.set("name","heatmap");

    heatmap.getSource().on('addfeature', function(event) {
      var name = event.feature.get('name');
      var magnitude = parseFloat(name.substr(2));
      event.feature.set('weight', magnitude - 5);
    });

    heatmap.setVisible(false);
    map.addLayer(heatmap);
  }






// 弹出气泡方法  事件   obj 数据   layerName 图层名称
  function popupWindow(evt, feature, layerName) {
    let obj=feature.get("data");
    if(!obj){
      obj=feature;//说明是外部被动调用
    }
    var coordinate;
    if(!evt){
      //这时候需要定位  被动显示
      // var coordinate = evt.event.coordinate;
      var endCenter4326 = [obj.lon,obj.lat];
      coordinate=transform(endCenter4326, 'EPSG:4326','EPSG:3857')
      mainMap.setCenterAndZoom( endCenter4326,null);
    }else{
      //点击地图触发
      coordinate = evt.event.coordinate;
    }
    mainMap.overlay.setPosition(transform(coordinate, 'EPSG:4326','EPSG:3857'));
  }

  obj.popupWindow=popupWindow;


  return obj;
}

export {startDataClass}
