/**
 * Created by cp on 2018/7/2.
 */
// 定义类
class LayerFuncServer {


  constructor(vueThis) {
    this.vm = vueThis;//类中变量
  }

  //类中函数
  getLayerByMapId(mapId,succFunc,failFunc){
    var param=this.getSearchQuery();
    let vm = this.vm;
    var tempToken =this.token;
    vm.$https({
      url: 'layer/getAllLayerByMapId',
      method: 'get',authType:tempToken
    }, param).then((res) => {
      if(succFunc){
        succFunc(res);
      }
    }, (error) => {
      vm.$message({message: res.data.message, type: 'error'});
      if(failFunc){
        failFunc();
      }
    })
  }


  //获取当前查询参数
  getSearchQuery(){
    let searchObj = {
    }
    if(this.mapId){
      searchObj.mapId=this.mapId;
    }
    return searchObj
  }


  setMapId(tempMapId){
    this.mapId=tempMapId;
  }

  setToken(tempToken){
    this.token=tempToken;
  }


  deleteLayer(layerId,succFunc,failFunc){
    let vm=this.vm;
    var tempToken =this.token;
    //删除活动事件
    vm.$confirm('此操作将删除该图层, 是否继续?', '提示', {
      confirmButtonText: '确定',
      cancelButtonText: '取消',
      type: 'warning',
    }).then(() => {
      vm.$https({
        url:'/layer/delete?id='+layerId,
        method:'delete',authType:tempToken,
      },{})
        .then((res) => {
            let data=res.data;
            //重新查询数据
            if(res.data.status==200||res.data.status==201||res.data.status==203||res.data.status==204){
              vm.$message({
                type: 'success',
                message: '删除成功!'
              });
              if(succFunc){
                succFunc();
              }
            }else {
              vm.$message({
                type: 'fail',
                message: data
              });
            }
          },(error) => {
            vm.$message({
              type: 'fail',
              message: "删除用户失败!"+error.response.data
            });
          }
        )



    }).catch(() => {
      this.$message({
        type: 'info',
        message: '已取消删除'
      });
    });
  }


  addLayer(searchObj,succFunc,failFunc) {
    var vm= this.vm;
    if(!searchObj.mapId){
      searchObj.mapId=this.mapId;
    }
    var param= vm.$querystring.stringify(searchObj);
    var tempToken =this.token;
    if(searchObj.id&&searchObj.id!=""){
      vm.$https({
        url:'/layer/edit',
        method:'put',authType:tempToken,
      },param)
        .then((res) => {
            if(succFunc){
              succFunc(res);
            }
          }, (error) => {
            vm.$message({message: error.data.message, type: 'error'});
            if(failFunc){
              failFunc(error);
            }
          }
        )
    }else{
      vm.$https({
        url:'/layer/add',
        method:'post',authType:tempToken,
      }, param)
        .then((res) => {
            if(succFunc){
              succFunc(res);
            }
          }, (error) => {
            vm.$message({message: error.data.message, type: 'error'});
            if(failFunc){
              failFunc(error);
            }
          }
        )
    }
  }



}


//静态变量
// Point.para = 'Allen';
export {LayerFuncServer};
