/**
 * Created by cp on 2016/8/25.
 */

var mapResoultion=[ 156543.03390625, 78271.516953125,39135.7584765625,19567.87923828125,9783.939619140625,4891.9698095703125 ,2445.9849047851562
  ,1222.9924523925781,611.4962261962891,305.74811309814453,152.87405654907226,76.43702827453613,38.218514137268066,19.109257068634033,
  9.554628534317017,4.777314267158508,2.388657133579254,1.194328566789627,0.5971642833948135,0.2985821416974068,0.1492910708487034,0.0746455354243517,0.0373227677121759];




import WKT from 'ol/format/WKT';
import Icon from 'ol/style/Icon';
import CircleStyle from 'ol/style/Circle';
import Style from 'ol/style/Style';
import Fill from 'ol/style/Fill';
import Stroke from 'ol/style/Stroke';
import Text from 'ol/style/Text';
import Circle from 'ol/geom/Circle';
import Feature from 'ol/Feature';

import {Tile as TileLayer, Vector as VectorLayer} from 'ol/layer';
import {OSM, Vector as VectorSource} from 'ol/source';

function BaseLayer(map,maxL,minL,layerName,vueThis){
  var  map =map;
  var obj={};
  let layerId=layerName;
  var maxResolution=611.4962261962891;
  var minResolution=0.0373227677121759;
  if(mapResoultion[maxL]){
    maxResolution=mapResoultion[maxL]
  }
  if(mapResoultion[minL]){
    minResolution=mapResoultion[minL]
  }

  var pLayer;
  var pSource;
//面的图层
  pLayer=getLyaersByName(layerName)
  if(pLayer){
    pSource=pLayer.getSource();
  }

  if(!pLayer){
    pSource = new VectorSource();
    pLayer = new VectorLayer({
      zIndex:10,
      id:layerName,
      source: pSource,
      minResolution:minResolution,
      maxResolution:maxResolution
    });
    pLayer.set("name",layerName);
    map.addLayer(pLayer);
  }

  function clean(){
    pSource.clear();
  }
  obj.clean=clean;
  function getLayer(){
    return pLayer;
  }
  obj.getLayer=getLayer;

  function  addFeatureArr(dataArr){
    $(dataArr).each(function(i,val) {
      addfeature(val);
    });
  }
  obj.addFeatureArr=addFeatureArr;

  function  getFeatureById(tempId){
    var features=pSource.getFeatures();
    var reArr=[];
    for(var i=0;i<features.length;i++){
      var f1=features[i];
      var currId= f1.getId();
      if(currId==tempId){
        reArr.push(f1);
      }
    }

    return reArr;
  }
  obj.getFeatureById=getFeatureById;


  function removeFeatureById(tempid){
    var reArr=[];
    reArr=getFeatureById(tempid);
    $(reArr).each(function(k,val) {
      pSource.removeFeature(val);
    })
  }
  obj.removeFeatureById=removeFeatureById;




  //WKT转换
  let wktFormat = new WKT();

  function addfeature(data){
    if(data.coordinate){
      data.wkt=data.coordinate;
    }
    if(!data.wkt){
      return ;
    }
    let feature ;
    let  styleObj={};

    // {"strokeColor":"#F8FAFB","strokeWeight":9,"strokeAlpha":0.51,"fillAlpha":0.7,"fillColor":"#994B4B","fileRadio":18,"imageSrc":null,"lineDash":1,"type":"Polygon"}
    data.isPoint=false;

    feature = wktFormat.readFeature(data.wkt, {
      dataProjection: 'EPSG:4326',
      featureProjection: 'EPSG:3857'
    });
    if(data.type==vueThis.POINT_TYPE){
      data.isPoint=true;
      styleObj.icon=data.imageUrl;
      styleObj.width=data.width;
      styleObj.hight=data.hight;
    } else{
      styleObj=JSON.parse( '{"strokeColor":"#F8FAFB","strokeWeight":2,"strokeAlpha":0.51,"fillAlpha":0.7,"fillColor":"#994B4B","fileRadio":18,"imageSrc":null,"lineDash":1,"type":"Polygon"}');
    }

    feature.setId(data.id);//存数据库中的ID  feature如果是从数据库中读取此ID必须有，不然会出现编辑错误
    if(data.maxZoom){
      feature.set("maxZoom",data.maxZoom);
    }
    data.layerId=layerId;
    feature.set("data",data,false);//data改变不触发事件
    feature.setStyle( getStyle(styleObj,data.isPoint));

    pSource.addFeature(feature);
    featureAddevent(feature);
  }
  //图层点击的回调方法
  var clickCallBackFunc;
  function  setCallbackFunc(fun){
    clickCallBackFunc=fun;
  }
  obj.setCallbackFunc=setCallbackFunc;


  function  featureAddevent(f1){
    f1.on('singleclick', function(event){
      //添加鼠标点击事件的方法
      clickCallBackFunc(event,f1,layerName);
    });
    f1.set('singleclick',true);//标识改点存在点击事件

    f1.on('onMouseOver', function(event){
      //添加鼠标点击事件的方法
    });

    f1.on('onMouseOut', function(event){
      //添加鼠标点击事件的方法
    });

    f1.on('onMouseMoveOver', function(event){
      //添加鼠标点击事件的方法
      if(tootipFunc){
        tootipFunc(event,f1,layerName);
      }
    });
  }
  obj.addfeature=addfeature;



  var tootipFunc;
  function  setShowTootip(func){
    tootipFunc=func;
  }
  obj.setShowTootip=setShowTootip;



//面的样式




//面的样式
  function getStyle(styleData,isPoint){
    if(styleData.fillColor){
      styleData.fillColor =  styleData.fillColor.colorRgba(styleData.fillAlpha);
    }
    if(styleData.strokeColor){
      styleData.strokeColor =  styleData.strokeColor.colorRgba(styleData.strokeAlpha);
    }
    var tempPointStyle;
    //如果是点;
    let drawStyle;
    if(isPoint){

      if(styleData.icon&&styleData.icon!=""){
        tempPointStyle= new Icon(({
          anchor: [0.5, 0.5],
          // size:[styleData.width,styleData.height],
          src: styleData.icon,
          opacity:1
        }));
      }else{
        tempPointStyle=new CircleStyle({
          radius:styleData.fileRadio,
          fill: new Fill({
            color:  styleData.fillColor
          }),
          stroke: new Stroke({
            color:styleData.strokeColor,
            width: styleData.strokeWeight
          })
        })
      }

      drawStyle=new  Style({
        image:tempPointStyle
      })
    }else{


      let storkobj={};
      storkobj.color=styleData.strokeColor;
      storkobj.width=styleData.strokeWeight;
      if(styleData.lineDash&&styleData.lineDash!=null){
        storkobj.lineDash=getLineDash(styleData.lineDash);
      }
      storkobj.lineCap="round";
      drawStyle=new Style({
        stroke: new Stroke(storkobj),
        fill: new Fill({
          color:styleData.fillColor
        }),
      })
    }
    return drawStyle;
  }



  function getLineDash(dashType){
    let endArr=[0];
    // vueThis.lineDashArr.forEach(function(item,index){
    //   if(dashType==item.type){
    //     endArr=item.dashArr;
    //     return  false ;
    //   }
    // })
    return false;
    // return  endArr;
  }


  function setFontStyle(styObj){
    var align ="center";
    var baseline = "top";
    var size ="14px";
    var offsetX = 0;
    var offsetY = 0;
    var weight ="bold";
    var rotation = 0;
    var font = weight + ' ' + size + ' ' + "Verdana";
    var fillColor = "#444444";
    var outlineColor ="#ffffff";
    var outlineWidth =1;
    var fillAlpha=1;
    var strokeAlpha=1;
    styObj.fillColorRgba  = fillColor.colorRgba(styObj.fillAlpha);
    styObj.outlineColorRgba= outlineColor.colorRgba(styObj.strokeAlpha);
    styObj.font = styObj.weight + ' ' + styObj.size+"px" + ' ' + "Verdana";
  }
  obj.setFontStyle=setFontStyle;





//赋予文字信息
  var createTextStyle = function(data) {
    let textLabel=data.name;
    if(!textLabel||textLabel==""){
      return null;
    }

    var fezoom=data.maxZoom;
    if(fezoom){
      var mapRe=map.getView().getResolution();
      var feRe=mapResoultion[fezoom]
      if(mapRe<feRe){
      }  else{
        textLabel="";
      }
    }
    let textFont =data.weight + ' ' + data.size+"px" + ' ' + data.font;
    return new  Text({
      textAlign: data.align,
      textBaseline: data.baseline,
      font: textFont,
      text: textLabel,
      fill: new  Fill({color: data.fillColor}),
      stroke: new  Stroke({color: data.outlineColor, width: data.outlineWidth}),
      offsetX: data.offsetX,
      offsetY: data.offsetY,
      rotation: data.rotation
    });
  };

  var getText = function(feature, resolution) {
    var type ="normal";
    var maxResolution = "1200";
    var text = feature.get('name');

    if (resolution > maxResolution) {
      text = '';
    } else if (type == 'hide') {
      text = '';
    } else if (type == 'shorten') {
      text = text.trunc(12);
    } else if (type == 'wrap') {
      text = stringDivider(text, 16, '\n');
    }

    return text;
  };




//判断图层是否存在
  function  getLyaersByName(layerName){
    var arrGroup=map.getLayerGroup().getLayers().getArray();

    for(var j=0;j<arrGroup.length;j++){
      var tempobj=arrGroup[j];
      //lk 图层组 className
      //H 图层
      var classType=tempobj.constructor.name;


      var  isArr=false;

      if(tempobj.getLayers&&tempobj.getLayers()){
        isArr=true;
      }

      if(!isArr){
        //适量图层
        if(tempobj.get("name")&&tempobj.get("name")==layerName){
          //存在
          return tempobj;
        }
      }else if(isArr){
        //s数组
        var  arr1s=tempobj.getLayers().getArray();
        for(var i=0;i<arr1s.length;i++){
          var  layer1=arr1s[i];
          if(layer1.get("name")&&layer1.get("name")==layerName){
            //存在
            return layer1;
          }
        }
      }
    }
    return null;
  }

  return obj;
}

export {BaseLayer}
