// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import $ from 'jquery'

import moment from 'moment'
import Vuex from 'vuex'
import qs from 'qs'
import axios from 'axios'
import {baseUrl,weUrl,backToken,frontToken, appHomeUrl,skipLinkUrl} from './config/env'
import http from './config/httpServer'
import store from './store/'
import {shortcuts} from './common/js/commonJs'
import VueDND from 'awe-dnd'

import echarts from 'echarts'

Vue.prototype.$echarts = echarts

//引入编辑器
import '../static/ueditor/ueditor.config.js'
import '../static/ueditor/ueditor.all.js'
import '../static/ueditor/themes/default/css/ueditor.min.css'
import '../static/ueditor/lang/zh-cn/zh-cn.js'

Vue.filter('dateformat', function(dataStr, pattern = 'YYYY-MM-DD HH:mm:ss') {
  return moment(dataStr).format(pattern)
})



Vue.prototype.$querystring = qs//其他的代码用到比较多  就新增一个

Vue.prototype.$qs = qs
Vue.prototype.$http = axios
Vue.prototype.$https = http
Vue.prototype.$store = store
Vue.prototype.$baseUrl=baseUrl
Vue.prototype.$weUrl=weUrl
Vue.prototype.$appHomeUrl=appHomeUrl
Vue.prototype.$skipLinkUrl=skipLinkUrl
Vue.prototype.backToken=backToken
Vue.prototype.frontToken=frontToken
Vue.prototype.moment = moment
Vue.prototype.shortcuts = shortcuts;

Vue.use(VueDND)
Vue.use(ElementUI);
Vue.use(Vuex);
Vue.config.productionTip = false

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})

