import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router);

///首页
const indexPage = r => require.ensure([], () => r(require('@/page/end/indexPage')), 'indexPage');

// 呼叫记录
const callHistory = r => require.ensure([], () => r(require('@/page/end/callHistory')), 'callHistory');
///意见建议及反馈
const feedbackPage = r => require.ensure([], () => r(require('@/page/end/feedbackPage')), 'feedbackPage');
const hallDirectorPage = r => require.ensure([], () => r(require('@/page/end/hallDirectorPage')), 'hallDirectorPage');

const page403 = r => require.ensure([], () => r(require('@/page/errorPage/page403')), 'page403');
const page404 = r => require.ensure([], () => r(require('@/page/errorPage/page404')), 'page404');
const page500 = r => require.ensure([], () => r(require('@/page/errorPage/page500')), 'page500');

/*内容管理*/
// 业务服务指南
const serviceGuidePage = r => require.ensure([], () => r(require('@/page/end/serviceGuidePage')), 'serviceGuidePage');
// 网点服务地图
const serviceDirectoryPage = r => require.ensure([], () => r(require('@/page/end/serviceDirectoryPage')), 'serviceDirectoryPage');
// 热门产品
const hotProductsPage = r => require.ensure([], () => r(require('@/page/end/hotProductsPage')), 'hotProductsPage');
//热门活动
const popularActivitiesPage = r => require.ensure([], () => r(require('@/page/end/popularActivitiesPage')), 'popularActivitiesPage');

// 系统管理
const userManagePage = r => require.ensure([], () => r(require('@/page/end/userManagePage')), 'userManagePage');
const roleManagePage = r => require.ensure([], () => r(require('@/page/end/roleManagePage')), 'roleManagePage');
const branchesManagePage = r => require.ensure([], () => r(require('@/page/end/branchesManagePage')), 'branchesManagePage');
const permissionsManagePage = r => require.ensure([], () => r(require('@/page/end/permissionsManagePage')), 'permissionsManagePage');
//菜单管理
const menuManagePage = r => require.ensure([], () => r(require('@/page/end/menuManagePage')), 'menuManagePage');
const analysisPage = r => require.ensure([], () => r(require('@/page/end/analysisPage')), 'analysisPage');
///预约记录
const hotProductsRecord = r => require.ensure([], () => r(require('@/page/end/hotProductsRecord')), 'hotProductsRecord');
const popularActiveRecord = r => require.ensure([], () => r(require('@/page/end/popularActiveRecord')), 'popularActiveRecord');

// 内容管理
const videoCopyright = r => require.ensure([], () => r(require('@/page/content/video/copyright/index')), 'videoCopyright');
const videoCopyrightAdd = r => require.ensure([], () => r(require('@/page/content/video/copyright/add')), 'videoCopyrightAdd');
const videoCopyrightUpdate = r => require.ensure([], () => r(require('@/page/content/video/copyright/add')), 'videoCopyrightUpdate');

const videoContent = r => require.ensure([], () => r(require('@/page/content/video/content/index')), 'videoContent');
const videoContentAdd = r => require.ensure([], () => r(require('@/page/content/video/content/add')), 'videoContentAdd');
const videoContentUpdate = r => require.ensure([], () => r(require('@/page/content/video/content/add')), 'videoContentUpdate');

/*跳转的页面*/
// 新建服务指南
const newServiceGuide = r => require.ensure([], () => r(require('@/page/routerPage/newServiceGuide')), 'newServiceGuide');
// 新建网络服务地图
const newDirectory = r => require.ensure([], () => r(require('@/page/routerPage/newDirectory')), 'newDirectory');


// 新建网络服务地图
const hotSpotManage = r => require.ensure([], () => r(require('@/page/routerPage/hotSpotManage')), 'hotSpotManage');

// 新增热门服务
const newHotPro = r => require.ensure([], () => r(require('@/page/routerPage/newHotPro')), 'newHotPro');
// 新增业务
const newPopActivity = r => require.ensure([], () => r(require('@/page/routerPage/newPopActivity')), 'newPopActivity');
//审核 auditMsg  auditMap auditProductActivity
const auditMsg = r => require.ensure([], () => r(require('@/page/routerPage/auditMsg')), 'auditMsg');
const auditMap = r => require.ensure([], () => r(require('@/page/routerPage/auditMap')), 'auditMap');
const auditProductActivity = r => require.ensure([], () => r(require('@/page/routerPage/auditProductActivity')), 'auditProductActivity');


//管理
const menuRouter = r => require.ensure([], () => r(require('@/page/end/menuRouter')), 'menuRouter');
// 登录
const login = r => require.ensure([], () => r(require('@/components/end/login')), 'login');
// 忘记密码
const forgetPassword = r => require.ensure([], () => r(require('@/components/end/forgetPassword')), 'forgetPassword');
// 首页
import { statisticsRoute } from './statistics'
import { systemRoute } from './system'
import { accoutsRoute } from './accout'
import { STBoxRoute } from './STBox'
const router = new Router({
  routes: [
    {
      path: '/',
      redirect:'/login'
    },
    {
      path: '/login',
      name: '登录',
      component: login,
      meta:{
        noShowbar:true
      }
    },
    {
      path: '/index',
      name: '首页',
      component: () => import('@/page/index/index'),
      meta: {
        isRequireLogin: true,
        showBreadcrumb: false
      }
    },
    ...statisticsRoute,
    ...systemRoute,
    ...accoutsRoute,
    ...STBoxRoute,
    {
      path: '/forgetPassword',
      name: '忘记密码',
      component: forgetPassword
    },
    {
      path: '/menuRouter',
      component: menuRouter,
      meta: {
        requireBackLogin: true
      },
      children: [
        {
          path: '/indexPage',
          name: '首页',
          component: indexPage
        },
        {
          path: '/callHistory',
          name: '呼叫记录 ',
          component: callHistory
        },
        {
          path: '/feedbackPage',
          name: '意见建议及反馈',
          component: feedbackPage
        },
        {
          path: '/hallDirectorPage',
          name: '支行人员管理',
          component: hallDirectorPage
        },
        {
          path: '/page403',
          name: '报错页面',
          component: page403
        },
        {
          path: '/page404',
          name: '报错页面',
          component: page404
        },
        {
          path: '/page500',
          name: '报错页面',
          component: page500
        },

        //内容管理
        {
          path: '/serviceGuidePage',
          name: '业务服务指南',
          component: serviceGuidePage
        },
        {
          path: '/serviceDirectoryPage',
          name: '网点服务地图',
          component: serviceDirectoryPage
        },
        {
          path: '/hotProductsPage',
          name: '热门产品',
          component: hotProductsPage
        },
        {
          path: '/popularActivitiesPage',
          name: '热门活动',
          component: popularActivitiesPage
        },

        //系统管理
        {
          path: '/userManagePage',
          name: '用户管理',
          component: userManagePage
        },
        {
          path: '/roleManagePage',
          name: '角色管理',
          component: roleManagePage
        },
        {
          path: '/branchesManagePage',
          name: '网点管理',
          component: branchesManagePage
        },
        {
          path: '/permissionsManagePage',
          name: '权限管理',
          component: permissionsManagePage
        },
        {
          path: '/menuManagePage',
          name: '菜单管理',
          component: menuManagePage
        },
        {
          path: '/analysisPage',
          name: '分析管理',
          component: analysisPage
        },
        //预约记录
        {
          path: '/hotProductsRecord',
          name: '热门产品',
          component: hotProductsRecord
        },
        {
          path: '/popularActiveRecord',
          name: '热门活动',
          component: popularActiveRecord
        },

        // --- 国博内容管理
        {
          path: '/videoCopyrightAdd',
          name: '新建版权方',
          component: videoCopyrightAdd,
          meta: {
            showBreadcrumb: true,
            title: '新建版权方',
          }
        },
        {
          path: '/videoCopyrightUpdate',
          name: '修改版权方',
          component: videoCopyrightUpdate,
          meta: {
            showBreadcrumb: true,
            title: '修改版权方',
          }
        },

        // {
        //   path: '/videoContent',
        //   name: '视频内容管理',
        //   component: videoContent
        // },
        {
          path: '/videoContentAdd',
          name: '新建视频',
          component: videoContentAdd,
          meta: {
            showBreadcrumb: true,
            title: '新建视频',
          }
        },
        {
          path: '/videoContentUpdate',
          name: '修改视频',
          component: videoContentUpdate,
          meta: {
            showBreadcrumb: true,
            title: '修改视频',
          }
        },
        {
          path: '/videoCopyright',
          name: '视频版权方管理',
          component: () => import('@/page/content/video/copyright/index'),
          meta: {
            showBreadcrumb: true,
            title: '视频版权方管理',
          }
        },
        {
          path: '/videoClassify',
          name: '视频分类管理',
          component: () => import('@/page/content/video/classify/index'),
          meta: {
            showBreadcrumb: true,
            title: '视频分类管理',
          }
        },
        {
          path: '/videoContent',
          name: '视频内容管理',
          component: () => import('@/page/content/video/content/index'),
          meta: {
            showBreadcrumb: true,
            title: '视频内容管理',
          }
        },
        {
          path: '/videoRemit',
          name: '视频汇出',
          component: () => import('@/page/content/video/remit/index'),
          meta: {
            showBreadcrumb: true,
            title: '视频汇出',
          }
        },

        // --- 展板
        {
          path: '/displayCopyright',
          name: '展板版权方管理',
          component: () => import('@/page/content/display/copyright/index'),
          meta: {
            showBreadcrumb: true,
            title: '展板版权方管理',
          }
        },
        {
          path: '/displayClassify',
          name: '展板分类管理',
          component: () => import('@/page/content/display/classify/index'),
          meta: {
            showBreadcrumb: true,
            title: '展板分类管理',
          }
        },
        {
          path: '/displayContent',
          name: '展板内容管理',
          component: () => import('@/page/content/display/content/index'),
          meta: {
            showBreadcrumb: true,
            title: '展板内容管理',
          }
        },
        {
          path: '/displayContentAdd',
          name: '新建展板',
          component: () => import('@/page/content/display/content/add'),
          meta: {
            showBreadcrumb: true,
            title: '新建展板',
          }
        },
        {
          path: '/displayContentUpdate',
          name: '修改展板',
          component: () => import('@/page/content/display/content/add'),
          meta: {
            showBreadcrumb: true,
            title: '修改展板',
          }
        },
        {
          path: '/displayContentDetails',
          name: '展板管理详情',
          component: () => import('@/page/content/display/content/details'),
          meta: {
            showBreadcrumb: true,
            title: '展板管理详情',
          }
        },
        // --学习
        {
          path: '/learnProject',
          name: '学习项目制作',
          component: () => import('@/page/content/learn/project/index'),
          meta: {
            showBreadcrumb: true,
            title: '学习项目制作',
          }
        },
        {
          path: '/learnContent',
          name: '学习内容制作',
          component: () => import('@/page/content/learn/content/index'),
          meta: {
            showBreadcrumb: true,
            title: '学习内容制作',
          }
        },
        {
          path: '/learnContentAdd',
          name: '新建学习内容',
          component: () => import('@/page/content/learn/content/add'),
          meta: {
            showBreadcrumb: true,
            title: '新建学习内容',
          }
        },
        {
          path: '/learnContentUpdate',
          name: '修改学习内容',
          component: () => import('@/page/content/learn/content/add'),
          meta: {
            showBreadcrumb: true,
            title: '修改学习内容',
          }
        },
        {
          path: '/learnContentDetails',
          name: '学习内容详情',
          component: () => import('@/page/content/learn/content/details'),
          meta: {
            showBreadcrumb: true,
            title: '学习内容详情',
          }
        },

        // 审核
        {
          path: '/checkVideo',
          name: '视频审核',
          component: () => import('@/page/check/video/index'),
          meta: {
            showBreadcrumb: true,
            title: '视频审核',
          }
        },
        {
          path: '/checkDisplay',
          name: '展板审核',
          component: () => import('@/page/check/display/index'),
          meta: {
            showBreadcrumb: true,
            title: '展板审核',
          }
        },
        {
          path: '/checkLearn',
          name: '平台学习内容审核',
          component: () => import('@/page/check/learn/index'),
          meta: {
            showBreadcrumb: true,
            title: '平台学习内容审核',
          }
        },
        {
          path: '/checkLearnDetails',
          name: '学习内容详情',
          component: () => import('@/page/check/learn/details'),
          meta: {
            showBreadcrumb: true,
            title: '学习内容详情',
          }
        },



        //新建页面
        {
          path: '/newServiceGuide',
          name: '新建业务指南',
          component: newServiceGuide
        },
        {
          path: '/newDirectory',
          name: '新增网点地图',
          component: newDirectory
        },
        {
          path: '/hotSpotManage',
          name: 'hotSpotManage',
          component: hotSpotManage
        },
        {
          path: '/newHotPro',
          name: '新增产品',
          component: newHotPro
        },
        {
          path: '/newPopActivity',
          name: '新增活动',
          component: newPopActivity
        },
        {
          path: '/auditMsg',
          name: '审核业务',
          component: auditMsg
        },
        {
          path: '/auditMap',
          name: '审核地图',
          component: auditMap
        },
        {
          path: '/auditProductActivity',
          name: '审核活动产品',
          component: auditProductActivity
        },
      ]
    },


  ]
})
router.beforeEach((to, from, next) => {
  if (to.meta.requireBackLogin) {
    let user = localStorage.getItem("userId");
    if (user) {  // 通过vuex state获取当前的token是否存在
      return next();
    } else {
      next({
        path: '/',
        query: { redirect: to.fullPath },
      })
    }
  } else {
    next();
  }
})
export default router
