// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import $ from 'jquery'

import moment from 'moment'
import Vuex from 'vuex'
import qs from 'qs'
import axios from 'axios'
import {backToken} from './config/env'
import http from './config/httpServer'

import echarts from 'echarts'
import Video from 'video.js'
import 'video.js/dist/video-js.css'

Vue.prototype.$echarts = echarts



// 引入JsPdf
import exportToPdf　from "@/utils/exportToPdf"
Vue.use(exportToPdf)

Vue.filter('dateformat', function(dataStr, pattern = 'YYYY-MM-DD HH:mm:ss') {
  return moment(dataStr).format(pattern)
})



Vue.prototype.$querystring = qs//其他的代码用到比较多  就新增一个

Vue.prototype.$qs = qs
Vue.prototype.$http = axios
Vue.prototype.$https = http
Vue.prototype.backToken=backToken
Vue.prototype.moment = moment

Vue.use(ElementUI);
Vue.use(Vuex);
Vue.config.productionTip = false

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  components: { App },
  template: '<App/>'
})

