import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router);
// 登录
const login = r => require.ensure([], () => r(require('@/components/end/login')), 'login');
// 首页
import { statisticsRoute } from './statistics'
import { systemRoute } from './system'
import { accoutsRoute } from './accout'
import { STBoxRoute } from './STBox'
import { learnRoute } from './learn'
const router = new Router({
  routes: [
    {
      path: '/',
      redirect: '/login'
    },
    {
      path: '/login',
      name: '登录',
      component: login,
      meta: {
        noShowbar: true,
        isNotRequireLogin: true,
      }
    },
    {
      path: '/index',
      name: '首页',
      component: () => import('@/page/index/index'),
      meta: {
        showBreadcrumb: false
      }
    },
    ...statisticsRoute,
    ...systemRoute,
    ...accoutsRoute,
    ...STBoxRoute,
    ...learnRoute
  ]
})
router.beforeEach((to, from, next) => {
  if (!to.meta.isNotRequireLogin) {
    let backToken = localStorage.getItem("backToken");
    if (backToken) {
      next()
    } else {
      next({
        path: '/',
        query: { redirect: to.fullPath },
      })
    }
  } else {
    next();
  }
})
export default router
