import request from '@/utils/request'

// 进件管理

//通讯录管理---表格---获取全部人员
export function getAllMemberList(data) {
  return request({
    url: '/admin/auth/addressbook/getUserAll',
    method: 'get',
    params: data
  })
}
// 获取未分组人员
export function getNoGroupMember(data) {
  return request({
    url: '/admin/auth/addressbook/getUserUnselected',
    method: 'get',
    params: data
  })
} 
//  获取柜组用户  
export function getGroupById(data) {
  return request({
    url: '/admin/auth/addressbook/getUserByShopId',
    method: 'get',
    params: data
  })
}
// 根据部门id获取人员
export function getMemberById(data) {
  return request({
    url: '/admin/auth/addressbook/getUserByStallId',
    method: 'get',
    params: data
  })
}
//通讯录管理---组织架构
export function getOrgTree() {
    return request({
      url: '/admin/auth/addressbook/addressBookPage',
      method: 'get',
    })
  }
export function getHistoryList(data) {
    return request({
      url: 'admin/auth/addressbook/synchronization',
      method: 'get',
      params:data
    })
  }
  export function deleteCounter(inData) {
    return request({
      url: '/admin/auth/stall/delete',
      method: 'delete',
      params: inData
    })
  }

  //  获取移动分组
  // /admin/auth/addressbook/synchronization
  export function getGroup() {
    return request({
      url: '/admin/auth/addressbook/selectGroupPage',
      method: 'get',
    })
  }

  // 修改门店名字
  export function storeNameChange(data) {
    return request({
      url: '/admin/auth/stall/update',
      method: 'put',
      data
    })
  }

  // 移动人员
  export function moveMember(data) {
    return request({
      url: 'admin/auth/addressbook/updateStallClerkByUserId',
      method: 'put',
      params:data
    })
  }

  // 模糊查询
  export function search(data) {
    return request({
      url: '/admin/auth/addressbook/getUserByKeyWords',
      method: 'get',
      params:data
    })
  }