import request from '@/utils/request'
import qs from 'qs'

export function ApiStoreGetMainList(inData) {
  return request({
    url: '/admin/auth/stall/stallPage',
    method: 'get',
    params: inData
  })
}

export function ApiStoreGetStoreDetail(inData) {
  return request({
    url: '/admin/auth/stall/get',
    method: 'get',
    params: inData
  })
}

export function ApiStoreAddStore(inData) {
  return request({
    url: '/admin/auth/stall/save',
    method: 'post',
    data: qs.stringify(inData)
  })
}

export function ApiStoreDelStore(inData) {
  return request({
    url: `/admin/auth/stall/delete`,
    method: 'post',
    data: qs.stringify(inData, {arrayFormat: 'repeat'})
  })
}

export function ApiStoreGetUnGroupManList(inData) {
  return request({
    url: '/admin/auth/addressbook/getUserUnselectedList',
    method: 'get',
    params: inData
  })
}

export function ApiStoreEditStore(inData) {
  return request({
    url: '/admin/auth/stall/update',
    method: 'put',
    data: qs.stringify(inData)
  })
}

export function ApiStoreGetBarList(inData) {
  return request({
    url: '/admin/auth/shop/shopPage',
    method: 'get',
    params: inData
  })
}

