import layoutHeaderAside from '@/layout/header-aside'

// 由于懒加载页面太多的话会造成webpack热更新太慢，所以开发环境不使用懒加载，只有生产环境使用懒加载
const _import = require('@/libs/util.import.' + process.env.NODE_ENV)
/**
 * 在主框架内显示
 */
const frameIn = [
  {
    path: '/',
    // redirect: { name: 'index' },
    // redirect: { name: 'homeMain' },
    redirect: { name: 'inContact' },
    component: layoutHeaderAside,
    children: [
      // 首页
      {
        path: 'index',
        name: 'index',
        meta: {
          auth: true
        },
        component: _import('system/index')
      },
      // Z-首页-首页
      // {
      //   path: '/home/main',
      //   name: 'homeMain',
      //   component: () => import('@/pages/home/main'),
      //   meta: {
      //     auth: true,
      //     title: '首页'
      //   }
      // },
      // Z-进件管理-通讯录管理
      {
        path: '/in/contact',
        name: 'inContact',
        component: () => import('@/pages/in/contact'),
        meta: {
          auth: true,
          title: '进件管理'
        }
      },
      // // Z-进件管理-通讯录管理
      // {
      //   path: '/in/bar',
      //   name: 'inBar',
      //   component: () => import('@/pages/in/bar'),
      //   meta: {
      //     auth: true,
      //     title: '柜组管理'
      //   }
      // },
      // // Z-进件管理-通讯录管理
      // {
      //   path: '/in/shop',
      //   name: 'inShop',
      //   component: () => import('@/pages/in/shop'),
      //   meta: {
      //     auth: true,
      //     title: '门店管理'
      //   }
      // },
      // Z-活动模版管理-模版中心
      {
        path: '/active/mode',
        name: 'activeMode',
        component: () => import('@/pages/active/mode'),
        meta: {
          auth: true,
          title: '模版中心'
        }
      },
      // Z-活动模版管理-模版商城
      {
        path: '/active/shop',
        name: 'activeMode',
        component: () => import('@/pages/active/shop'),
        meta: {
          auth: true,
          title: '模版商城'
        }
      },
      // Z-任务管理-柜组任务
      {
        path: '/task/main',
        name: 'taskMain',
        component: () => import('@/pages/task/main'),
        meta: {
          auth: true,
          title: '柜组任务'
        }
      },
      // Z-任务管理-集团任务
      {
        path: '/task/com',
        name: 'taskCom',
        component: () => import('@/pages/task/com'),
        meta: {
          auth: true,
          title: '集团任务'
        }
      },
      // Z-任务管理-任务统计
      {
        path: '/task/count',
        name: 'taskCount',
        component: () => import('@/pages/task/count'),
        meta: {
          auth: true,
          title: '任务统计'
        }
      },
      // Z-活动商品-活动商品
      {
        path: '/goods/main',
        name: 'goodsMain',
        component: () => import('@/pages/goods/main'),
        meta: {
          auth: true,
          title: '活动商品'
        }
      },
      // // 演示页面
      // {
      //   path: 'page1',
      //   name: 'page1',
      //   meta: {
      //     title: '页面 1',
      //     auth: true
      //   },
      //   component: _import('demo/page1')
      // },
      // {
      //   path: 'page2',
      //   name: 'page2',
      //   meta: {
      //     title: '页面 2',
      //     auth: true
      //   },
      //   component: _import('demo/page2')
      // },
      // {
      //   path: 'page3',
      //   name: 'page3',
      //   meta: {
      //     title: '页面 3',
      //     auth: true
      //   },
      //   component: _import('demo/page3')
      // },
      // {
      //   path: '/page-demo',
      //   name: 'page-demo',
      //   component: () => import('@/pages/page-demo'),
      //   meta: {
      //     auth: true,
      //     title: '新建示例'
      //   }
      // },
      // 系统 前端日志
      {
        path: 'log',
        name: 'log',
        meta: {
          title: '前端日志',
          auth: true
        },
        component: _import('system/log')
      },
      // 刷新页面 必须保留
      {
        path: 'refresh',
        name: 'refresh',
        hidden: true,
        component: _import('system/function/refresh')
      },
      // 页面重定向 必须保留
      {
        path: 'redirect/:route*',
        name: 'redirect',
        hidden: true,
        component: _import('system/function/redirect')
      }
    ]
  }
]

/**
 * 在主框架之外显示
 */
const frameOut = [
  // 登录
  {
    path: '/login',
    name: 'login',
    component: _import('system/login')
  }
]

/**
 * 错误页面
 */
const errorPage = [
  {
    path: '*',
    name: '404',
    component: _import('system/error/404')
  }
]

// 导出需要显示菜单的
export const frameInRoutes = frameIn

// 重新组织后导出
export default [
  ...frameIn,
  ...frameOut,
  ...errorPage
]
