import axios from 'axios'
import md5 from "js-md5"

let BASE_API = "http://139.155.48.151:8084"
const zlog = console.log.bind(console)


// 创建 axios 实例
const service = axios.create({
    baseURL: BASE_API,
    timeout: 20000
})

// request 拦截器
service.interceptors.request.use(
    request => {
        // zlog('--->request: request:', request)
        return request
    },
    error => {
        Promise.reject(error)
    }
)

// response 拦截器
service.interceptors.response.use(
    response => {
        const res = response.data
        return res
    },
    error => {
        return Promise.reject(error)
    }
)

export default service