import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/home.vue'

Vue.use(VueRouter)

const routes = [
  {
    path: '/',
    name: 'home',
    component: Home
  },
  {
    path: '/turntableDetail',
    name: 'turntableDetail',
    component: () => import('../views/active/turntableDetail.vue')
  },
  {
    path: '/couponDetail',
    name: 'couponDetail',
    component: () => import('../views/active/couponDetail.vue')
  },
  {
    path: '/createActive',
    name: 'createActive',
    component: () => import('../views/active/createActive.vue')
  },
  {
    path: '/activeList',
    name: 'activeList',
    component: () => import('../views/active/activeList.vue')
  },
  {
    path: '/createBigWheelActive',
    name: 'createBigWheelActive',
    component: () => import('../views/active/createBigWheelActive.vue')
  },
  {
    path: '/discount',
    name: 'Discount',
    component: () => import('@/views/sideNav/discount/index')
  },
  {
    path: '/mainSale',
    name: 'MainSale',
    component: () => import('@/views/mainSale/active/main/index')
  },
  {
    path: '/changeCounter',
    name: 'changeCounter',
    component: () => import('@/views/counter/changeCounter')
  },
  {
    path: '/counterInfo',
    name: 'counterInfo',
    component: () => import('@/views/counter/counterInfo')
  },
  {
    path: '/counterMaintain',
    name: 'counterMaintain',
    component: () => import('@/views/counter/counterMaintain')
  },
  {
    path: '/goodManage',
    name: 'goodManage',
    component: () => import('@/views/goods/goodManage')
  },
  {
    path: '/goodGrounding',
    name: 'goodGrounding',
    component: () => import('@/views/goods/goodGrounding')
  },
  {
    path: '/profitList',
    name: 'profitList',
    component: () => import('@/views/profit/index')
  },
  {
    path: '/actTemplate',
    name: 'ActTemplate',
    component: () => import('@/views/mainSale/active/template/index')
  },
  {
    path: '/me',
    name: 'Me',
    component: () => import('@/views/mainSale/me/main/index')
  },
  {
    path: '/task',
    name: 'Task',
    component: () => import('@/views/mainSale/me/task/index')
  },
  {
    path: '/taskList',
    name: 'taskList',
    component: () => import('@/views/task/taskList')
  },
  {
    path: '/newMemberTask',
    name: 'newMemberTask',
    component: () => import('@/views/task/newMemberTask')
  },
  {
    path: '/case',
    name: 'case',
    component: () => import('@/views/case/index')
  },
  {
    path: '/caseDetail',
    name: 'caseDetail',
    component: () => import('@/views/case/caseDetail')
  },
  {
    path: '/newInfo',
    name: 'newInfo',
    component: () => import('@/views/message/newInfo')
  },
  // {
  //   path: '/about',
  //   name: 'about',
  //   // route level code-splitting
  //   // this generates a separate chunk (about.[hash].js) for this route
  //   // which is lazy-loaded when the route is visited.
  //   component: () => import(/* webpackChunkName: "about" */ '../views/About.vue')
  // }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
