import Vue from 'vue'
import { wxRequest } from './aWxRequest'
import qs from 'qs'
import router from '../router'

// Z-BasicInfo
let INFO = {
  corpId: 'wwd1cdbca7b8b2b6c4',
  agentId: '1000015',
}

async function getXToken() {
  let postData = {
    corpId: INFO.corpId,
    agentId: INFO.agentId,
  }

  await wxRequest('/workWx/common/getToken', qs.stringify(postData)).then(res => {
    if (res.result == 'success') {
      sessionStorage.setItem('XToken', res.data)
    } else {
      this.$message({
        message: res.errorMsg,
        type: 'error'
      })
    }
  }).catch(err => {
    console.log('!==>getXToken: err:', err)
  })
}

function isIosOrAndroid() {
  let u = navigator.userAgent;
  let isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1 // android终端
  let isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/) // ios终端
  let isStr = ''
  if (isAndroid) {
    isStr = 'android'
  }
  if (isiOS) {
    isStr = 'ios'
  }
  return isStr
}

Vue.prototype.getAgentAuth = function () {
  let postData = {
    // businessId: sessionStorage.getItem('businessId'),
    // pageUrl: encodeURIComponent(this.isIosOrAndroid() === 'android' ? location.href.split('#')[0] : window.initUrl)
    pageUrl: encodeURIComponent(location.href.split('#')[0])
  }
  let header = {
    token: sessionStorage.getItem('XToken'),
    corpId: INFO.corpId,
    agentId: INFO.agentId,
  }
  wxRequest('/workWx/auth/base/getJsSdkSignature', qs.stringify(postData), header).then(res => {
    if (res.result == 'success') {
      let config = res.data
      wx.config({
        beta: true,
        debug: false, //调试的时候可以开启
        appId: config.jsApiSignature.appId, // 必填，公众号的唯一标识
        timestamp: config.jsApiSignature.timestamp, // 必填，生成签名的时间戳
        nonceStr: config.jsApiSignature.nonceStr, // 必填，生成签名的随机串 
        signature: config.jsApiSignature.signature, // 必填，签名
        // 根据自己的需求，填写 jsapilist 内容
        jsApiList: ['agentConfig']
      })
      wx.ready(function () {
        // JS-SDK配置信息验证失败时会进入此方法
        wx.error(function (res) {
          alert("JS-SDK配置信息验证失败 \r\n" + JSON.stringify(res));
        })
        // 配置成功后验证API接口在当前客户端是否支持：判断当前客户端版本是否支持指定JS接口
        wx.checkJsApi({
          jsApiList: ['agentConfig', 'sendChatMessage'],
          success: function (res) {
            if (res.errMsg != "checkJsApi:ok") {
              alert("JS-SDK接口检测失败:" + JSON.stringify(res));
              return false;
            } else {
              wxRequest('/workWx/auth/base/getAgentJsSdkSignature', qs.stringify(data), header).then(res => {
                // alert('getAgentJsSdkSignature:ok')
                if (res.result == 'success') {
                  let agentConfig = res.data
                  wx.agentConfig({
                    corpid: agentConfig.agentJsApiSignature.appId, // 必填，企业微信的corpid，必须与当前登录的企业一致
                    agentid: agentConfig.agentId, // 必填，企业微信的应用id
                    timestamp: agentConfig.agentJsApiSignature.timestamp, // 必填，生成签名的时间戳
                    nonceStr: agentConfig.agentJsApiSignature.nonceStr, // 必填，生成签名的随机串
                    signature: agentConfig.agentJsApiSignature.signature,// 必填，签名，agentConfig所以为应用签名
                    jsApiList: ['sendChatMessage'], //必填
                    success: function (res) {
                      // alert('agentConfig:ok')
                      // router.push(to)
                      // 回调
                      //1、发起申请申请时后，审批状态发生变化时
                      //2、发起申请申请时后，在“审批中”状态，有任意审批人进行审批操作时
                      // alert('wx.agentConfig 回调'+res.errMsg);
                    },
                    fail: function (res) {
                      // alert('回调失败：'+res.errMsg)
                      if (res.errMsg.indexOf('is not a function') > -1) {
                        alert('<i class="weui-icon-warn">版本过低请升级</i>')
                      }
                    }
                  })

                }
              })
            }
          }
        })
      })
    } else {
      this.$message({
        type: 'error',
        message: res.errorMsg
      })
    }
  }).catch(err => {
    console.log(err, 'err')
  })
}

function configWx(to) {
  let postData = {
    // businessId: sessionStorage.getItem('businessId'),
    // pageUrl: encodeURIComponent(this.isIosOrAndroid() === 'android' ? location.href.split('#')[0] : window.initUrl)
    pageUrl: encodeURIComponent(location.href.split('#')[0])
  }
  let header = {
    token: sessionStorage.getItem('XToken'),
    corpId: INFO.corpId,
    agentId: INFO.agentId,
  }
  wxRequest('/workWx/auth/base/getJsSdkSignature', qs.stringify(postData), header).then(res => {
    if (res.result == 'success') {
      let config = res.data
      wx.config({
        beta: true,
        debug: true, //调试的时候可以开启
        appId: config.jsApiSignature.appId, // 必填，公众号的唯一标识
        timestamp: config.jsApiSignature.timestamp, // 必填，生成签名的时间戳
        nonceStr: config.jsApiSignature.nonceStr, // 必填，生成签名的随机串 
        signature: config.jsApiSignature.signature, // 必填，签名
        // 根据自己的需求，填写 jsapilist 内容
        jsApiList: ['agentConfig']
      })
      wx.ready(function () {
        // JS-SDK配置信息验证失败时会进入此方法
        wx.error(function (res) {
          alert("JS-SDK配置信息验证失败 \r\n" + JSON.stringify(res));
        })
        // 配置成功后验证API接口在当前客户端是否支持：判断当前客户端版本是否支持指定JS接口
        wx.checkJsApi({
          jsApiList: ['agentConfig', 'getCurExternalContact'],
          success: function (res) {
            if (res.errMsg != "checkJsApi:ok") {
              alert("JS-SDK接口检测失败:" + JSON.stringify(res));
              return false;
            }
          }
        })

        wxRequest('/workWx/auth/base/getAgentJsSdkSignature', qs.stringify(data), header).then(res => {
          if (res.result == 'success') {
            let agentConfig = res.data
            wx.agentConfig({
              corpid: agentConfig.agentJsApiSignature.appId, // 必填，企业微信的corpid，必须与当前登录的企业一致
              agentid: agentConfig.agentId, // 必填，企业微信的应用id
              timestamp: agentConfig.agentJsApiSignature.timestamp, // 必填，生成签名的时间戳
              nonceStr: agentConfig.agentJsApiSignature.nonceStr, // 必填，生成签名的随机串
              signature: agentConfig.agentJsApiSignature.signature,// 必填，签名，agentConfig所以为应用签名
              jsApiList: ['getCurExternalContact'], //必填
              success: function (res) {
                // alert('agentConfig:ok')             
                // router.push(to)
                getUnionid(to)
                // 回调
                //1、发起申请申请时后，审批状态发生变化时
                //2、发起申请申请时后，在“审批中”状态，有任意审批人进行审批操作时
                // alert('wx.agentConfig 回调'+res.errMsg);
              },
              fail: function (res) {
                if (res.errMsg.indexOf('is not a function') > -1) {
                  alert('<i class="weui-icon-warn">版本过低请升级</i>')
                }
              }
            })
          }
        })
      })
    } else {
      this.$message({
        type: 'error',
        message: res.errorMsg
      })
    }
  }).catch(err => {
    console.log(err, 'err')
  })
}

function getUnionid(to) {
  wx.invoke('getCurExternalContact', {}, function (res) {
    if (res.err_msg == "getCurExternalContact:ok") {
      let header = {
        token: sessionStorage.getItem('XToken'),
        corpId: 'wwd1cdbca7b8b2b6c4',
        agentId: '1000009',
      }
      let postData = {
        userId: res.userId
      }
      wxRequest('/workWx/auth/contact/getExternalContact', postData, header, 'get').then(res => {
        if (res.result == 'success') {
          sessionStorage.setItem('unionid', res.data.externalContact.unionId)
          router.push(to)
        }
      })
    } else {
      console.log(res, 'res')
    }
  });
}


export { getXToken, configWx, getUnionid }
