import axios from 'axios'
import { Message, MessageBox } from 'element-ui'
import Router from '../router'
// import store from '../store'
// import { getToken } from '@/utils/auth'

// const testEnv = require('../../config/dev.env')
// Z-BasicInfo
let INFO = {
  corpId: 'wwd1cdbca7b8b2b6c4',
  agentId: '1000015',
  url: 'http://139.155.48.151:8085',
}

// 创建axios实例
const service = axios.create({
  baseURL: INFO.url, // api 的 base_url
  timeout: 50000 // 请求超时时间
})

// request拦截器
service.interceptors.request.use(
  (config) => {
    if (sessionStorage['token']) {
      config.headers['token'] = sessionStorage['token']
      config.headers['businessId'] = sessionStorage['businessId']
    } else {
      config.headers['businessId'] = '10'
    }
    return config;
  },
  (error) => {
    Promise.reject(error)
  }
)

// response 拦截器
service.interceptors.response.use(
  response => {
    console.log(response)
    if(response.status == 200) {
      return response.data
    } else {
      Message({
        message: response.data.msg,
        type: 'error',
        duration: 5 * 1000
      })
    }
    // let loadingSetting = Loading.service({
    //   fullscreen: true,
    //   lock: true,
    //   background: 'rgba(0,0,0,0.4)',
    //   text: '正在加载',
    //   spinner: 'el-icon-loading'
    // })
    // endLoading(loadingSetting)
    // if (response.errorCode == '1001') {
    //   Router.push({ path: "/login" });
    // }
  },
  error => {
    console.log(error)
    // console.log('err' + error) // for debug
    // Message({
    //   message: error.message,
    //   type: 'error',
    //   duration: 50 * 1000
    // })
    // return Promise.reject(error)
  }
)
// function endLoading (loading) {
//   store.commit('LOADING', false)
//   loading.close()
// }

// function startLoding () {
//   store.commit('LOADING', true)
// }
export default service
