import axios from 'axios'
import md5 from "js-md5"

// let BASE_API = "https://gd.chfatech.com/guangdian"
// let BASE_API = "/api/"
let BASE_API = "/api"

const zlog = console.log.bind(console)

// URL 编码与拼接
const createSign = (inPostData, inAppSecret) => {
    let appUser = inPostData.appUser
    let appCode = inPostData.appCode
    let ts = inPostData.ts
    let args = JSON.parse(JSON.stringify(inPostData.args));
    let appSecret = inAppSecret

    let res = "";

    // URL 编码
    for (let key in args) {
        res += encodeURIComponent(key) + "%3D" + encodeURIComponent(args[key]) + "%26";
    }
    res = res.slice(0, -3);

    // URL 拼接
    res += `&appUser=${appUser}&appCode=${appCode}&${ts}${appSecret}`

    return res;
};

// Basic Info
let basicInfo = {
    appUser: "YBF001",
    ver: "v2.17",
    appSecret: "t04yYm6gjsuHeehxOxojtmiwlYfXY8Zkdowf"
}

// 创建 axios 实例
const service = axios.create({
    baseURL: BASE_API,
    timeout: 20000
})

// request 拦截器
service.interceptors.request.use(
    req => {
        // zlog('--->axios: req.params: start:', req.params)
        let apiMethod = req.method

        if (apiMethod === 'post') {
            // zlog('--->axios: req.data:', req.data)
            let oldPostData = JSON.parse(JSON.stringify(req.data))
            let newPostData = {
                appUser: basicInfo.appUser,
                appCode: oldPostData.args.appCode,
                // ts: String(Date.parse(new Date())),
                // ts: String(parseInt(new Date().getTime()/1000)),
                ts: '1563355520',
                ver: basicInfo.ver,
                args: oldPostData.args
            }

            delete newPostData.args.appCode

            let postData = {
                appUser: newPostData.appUser,
                appCode: newPostData.appCode,
                ts: newPostData.ts,
                sign: md5(createSign(newPostData, basicInfo.appSecret)),
                ver: newPostData.ver,
                args: newPostData.args
            }

            req.data = postData
        }
        if (apiMethod === 'get') {
            // log('--->axios: req.data:', req.data)
            let oldPostData = JSON.parse(JSON.stringify(req.params))
            let newPostData = {
                appUser: basicInfo.appUser,
                appCode: oldPostData.args.appCode,
                ts: String(Date.parse(new Date())),
                ver: basicInfo.ver,
                args: oldPostData.args
            }

            delete newPostData.args.appCode

            let postData = {
                appUser: newPostData.appUser,
                appCode: newPostData.appCode,
                ts: newPostData.ts,
                sign: md5(createSign(newPostData, basicInfo.appSecret)),
                ver: newPostData.ver,
                args: newPostData.args
            }

            req.params = postData
        }

        // zlog('--->axios: req.params: end:', req.params)
        return req
    },
    error => {
        Promise.reject(error)
    }
)

// response 拦截器
service.interceptors.response.use(
    response => {
        const res = response.data
        return res
    },
    error => {
        return Promise.reject(error)
    }
)

export default service
