
// 拼接路径
const resolve = dir => require('path').join(__dirname, dir)

// 基础路径 注意发布之前要先修改这里
const publicPath = '/'

module.exports = {
  publicPath, // 根据你的实际情况更改这里
  lintOnSave: true,
  devServer: {
    publicPath, // 和 publicPath 保持一致
    disableHostCheck: false,
    https: false,
    hotOnly: false, // See https://github.com/vuejs/vue-cli/blob/dev/docs/cli-service.md#configuring-proxy
    proxy: {
      '/api': {
        ws: false,
        target: 'http://111.26.165.55:8010/crminterface.ashx',
        changeOrigin: true,
        pathRewrite: {
          '^/api': ''
        }
      },
    }
  },
  css: {
    loaderOptions: {
      sass: {
        prependData: `@import "~@/assets/style/public.scss";`,
      },
    }
  },

  // 默认设置: https://github.com/vuejs/vue-cli/tree/dev/packages/%40vue/cli-service/lib/config/base.js
  chainWebpack: config => {
    /**
     * 删除懒加载模块的 prefetch preload，降低带宽压力
     * https://cli.vuejs.org/zh/guide/html-and-static-assets.html#prefetch
     * https://cli.vuejs.org/zh/guide/html-and-static-assets.html#preload
     * 而且预渲染时生成的 prefetch 标签是 modern 版本的，低版本浏览器是不需要的
     */
    config.plugins.delete('prefetch').delete('preload')
    // 解决 cli3 热更新失效 https://github.com/vuejs/vue-cli/issues/1559
    config.resolve.symlinks(true)
    config
    // 开发环境
      .when(
        process.env.NODE_ENV === 'development',
        // sourcemap不包含列信息
        config => config.devtool('cheap-source-map')
      )
    // .when(process.env.NODE_ENV !== 'development', config => {
    //   config.optimization
    //     .minimizer([
    //       new UglifyJsPlugin({
    //         uglifyOptions: {
    //           // 移除 console
    //           // 其它优化选项 https://segmentfault.com/a/1190000010874406
    //           compress: {
    //             warnings: false,
    //             drop_console: true,
    //             drop_debugger: true,
    //             pure_funcs: ['console.log']
    //           }
    //         }
    //       })
    //     ])
    // })
    // // markdown
    // config.module
    //   .rule('md')
    //   .test(/\.md$/)
    //   .use('text-loader')
    //   .loader('text-loader')
    //   .end()
    // // i18n
    // config.module
    //   .rule('i18n')
    //   .resourceQuery(/blockType=i18n/)
    //   .use('i18n')
    //   .loader('@kazupon/vue-i18n-loader')
    //   .end()
    // svg
    const svgRule = config.module.rule('svg')
    svgRule.uses.clear()
    svgRule.include
      .add(resolve('src/assets/svg-icons/icons'))
      .end()
      .use('svg-sprite-loader')
      .loader('svg-sprite-loader')
      .options({
        symbolId: 'd2-[name]'
      })
      .end()
    // image exclude
    const imagesRule = config.module.rule('images')
    imagesRule
      .test(/\.(png|jpe?g|gif|webp|svg)(\?.*)?$/)
      .exclude.add(resolve('src/assets/svg-icons/icons'))
      .end()
    // 重新设置 alias
    config.resolve.alias.set('@api', resolve('src/api'))
    // node
    config.node.set('__dirname', true).set('__filename', true)
  }
}
