/*
 * Decompiled with CFR 0.152.
 */
package asposewobfuscated;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class \u00ebY4
implements BufferedImageOp {
    private RenderingHints hints;
    private float[][] matrix;
    private float[] \u00ebWK;
    private float[] \u00ebWJ;
    private boolean \u00ebWI;
    private boolean \u00ebWH = false;

    public \u00ebY4(float[][] fArray, RenderingHints renderingHints) {
        if (fArray == null || fArray.length != 5) {
            throw new IllegalArgumentException("ColorMatrix cannot be null and have to have dimension 5 to represents RGBAW space");
        }
        this.hints = renderingHints != null ? (RenderingHints)renderingHints.clone() : null;
        this.\u00ebWK = new float[]{fArray[0][0], fArray[1][1], fArray[2][2], fArray[3][3], fArray[4][4]};
        this.\u00ebWJ = new float[]{fArray[4][0], fArray[4][1], fArray[4][2], fArray[4][3], fArray[4][4]};
        this.\u00ebWI = this.\u00ebZ(fArray);
        this.\u00ebZ(this.\u00ebWI, " isMatrixHasOnlyRescaleOp=");
        this.matrix = (float[][])fArray.clone();
        this.\u00ebZ(fArray, "Origin Matrix");
        this.\u00ebZ(this.\u00ebWK, "Scale Vector");
        this.\u00ebZ(this.\u00ebWJ, "Translate Vector");
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == null) {
            throw new IllegalArgumentException("Src cannot be null");
        }
        src = this.\u00ebY(src);
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        this.\u00ebZ((Object)src, "Src");
        if (src.getColorModel() instanceof IndexColorModel) {
            return this.\u00ebZ(src, dst);
        }
        return this.\u00ebY(src, dst);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (src == null) {
            throw new IllegalArgumentException("Src cannot be null");
        }
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        WritableRaster writableRaster = destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        return new BufferedImage(destCM, writableRaster, destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private BufferedImage \u00ebZ(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.\u00ebZ("", " Index Image == ");
        if (this.\u00ebWI) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            indexColorModel.getAlphas(byArray4);
            this.\u00ebZ(byArray, this.\u00ebWK[0], this.\u00ebWJ[0]);
            this.\u00ebZ(byArray2, this.\u00ebWK[1], this.\u00ebWJ[1]);
            this.\u00ebZ(byArray3, this.\u00ebWK[2], this.\u00ebWJ[2]);
            this.\u00ebZ(byArray4, this.\u00ebWK[3], this.\u00ebWJ[3]);
            IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3, byArray4);
            bufferedImage2 = new BufferedImage(indexColorModel2, bufferedImage.getRaster(), false, null);
        } else {
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = this.\u00ebZ(bufferedImage3);
            this.\u00ebZ((Object)bufferedImage2, "dst");
        }
        return bufferedImage2;
    }

    private BufferedImage \u00ebY(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.\u00ebZ("", " RGBA ==");
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        if (this.\u00ebWI) {
            this.\u00ebZ(writableRaster, writableRaster2);
        } else {
            bufferedImage2 = this.\u00ebZ(bufferedImage);
        }
        return bufferedImage2;
    }

    private BufferedImage \u00ebZ(BufferedImage bufferedImage) {
        bufferedImage = this.\u00ebY(bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getNumBands();
        this.\u00ebZ(n, "Num Bands");
        float[][] fArray = new float[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j][i] = this.matrix[i][j];
            }
        }
        this.\u00ebZ(fArray, "my Matrix");
        BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
        WritableRaster writableRaster2 = bandCombineOp.createCompatibleDestRaster(writableRaster);
        bandCombineOp.filter(writableRaster, writableRaster2);
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster2, bufferedImage.getColorModel().isAlphaPremultiplied(), null);
    }

    private WritableRaster \u00ebZ(WritableRaster writableRaster, WritableRaster writableRaster2) {
        int n = writableRaster.getNumBands();
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int[] nArray = null;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n3; ++i) {
            nArray = writableRaster.getPixels(0, i, n2, 1, nArray);
            for (int j = 0; j < nArray.length; j += n) {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    nArray2[n4] = nArray[j + n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    nArray2[n4] = Math.round((float)nArray2[n4] * this.\u00ebWK[n4] + this.\u00ebWJ[n4] * 255.0f);
                }
                this.\u00ebZ(nArray2);
                for (n4 = 0; n4 < n; ++n4) {
                    nArray[j + n4] = nArray2[n4];
                }
            }
            writableRaster2.setPixels(0, i, n2, 1, nArray);
        }
        return writableRaster2;
    }

    private void \u00ebZ(byte[] byArray, float f, float f2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            int n2 = Math.round((float)n * f + f2 * 255.0f);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            byArray[i] = (byte)n2;
        }
    }

    private void \u00ebZ(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 255) {
                nArray[i] = 255;
                continue;
            }
            if (nArray[i] >= 0) continue;
            nArray[i] = 0;
        }
    }

    private boolean \u00ebZ(float[][] fArray) {
        return fArray[0][1] == 0.0f && fArray[0][2] == 0.0f && fArray[1][0] == 0.0f && fArray[1][2] == 0.0f && fArray[2][0] == 0.0f && fArray[2][1] == 0.0f;
    }

    private BufferedImage \u00ebY(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 2) {
            this.\u00ebZ("Convert to RGBA to improve of applying of ColorMatrixOp, otherwise the output could be darker/brighter", " Was numbands=" + bufferedImage.getRaster().getNumBands() + " type=" + bufferedImage.getType());
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    private void \u00ebZ(float[][] fArray, String string) {
        if (!this.\u00ebWH) {
            return;
        }
        System.out.println("\n=== " + string + " ===");
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                System.out.print(fArray[i][j] + " ");
            }
            System.out.println();
        }
    }

    private void \u00ebZ(float[] fArray, String string) {
        if (!this.\u00ebWH) {
            return;
        }
        System.out.println("\n=== " + string + " ===");
        for (int i = 0; i < fArray.length; ++i) {
            System.out.print(fArray[i] + " ");
        }
    }

    private void \u00ebZ(Object object, String string) {
        if (!this.\u00ebWH) {
            return;
        }
        System.out.println("\n" + string + " = " + object);
    }
}

