/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.\u00eb82;
import com.aspose.words.\u00eb86;
import com.aspose.words.\u00eb8G;
import com.aspose.words.\u00ebFP;
import com.aspose.words.\u00ebFQ;
import com.aspose.words.\u00ebFW;
import com.aspose.words.\u00ebUQ;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements \u00ebFP,
Iterable<T> {
    private Node \u00eb8s;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    boolean \u00eblG() {
        return this.\u00eblD() != null;
    }

    boolean \u00eblF() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    boolean \u00eblE() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof \u00ebFW)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.getLastChild() != null ? this.getLastChild().\u00ebZPN() : null;
    }

    public Node getLastChild() {
        return this.\u00eb8s;
    }

    Node \u00eblD() {
        return \u00eb82.\u00ebZL(this.getFirstChild());
    }

    Node \u00eblC() {
        return \u00eb82.\u00ebZK(this.getLastChild());
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node \u00ebZ(boolean bl, \u00ebFQ \u00ebFQ2) {
        CompositeNode compositeNode = (CompositeNode)super.\u00ebZ(bl, \u00ebFQ2);
        compositeNode.\u00eb8s = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.\u00ebQ(node.\u00ebZ(true, \u00ebFQ2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = this.\u00eblz();
        stringBuilder.append(this.\u00eblB());
        return stringBuilder.toString();
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    @Deprecated
    public NodeCollection getChildNodes(int nodeType, boolean isDeep, boolean isLive) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = \u00eb82.\u00ebJX(nodeType);
            Node node2 = node = bl ? this.\u00eblD() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.\u00ebZPQ() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return \u00ebUQ.\u00ebW(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return \u00ebUQ.\u00ebV(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new \u00eb8G(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.\u00ebZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.\u00ebZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.\u00ebZ(oldChild, this, null, 1);
        if (nodeChangingArgs != null) {
            documentBase.\u00ebZ(nodeChangingArgs);
        }
        if (oldChild == this.getFirstChild()) {
            if (this.getLastChild().\u00ebZPN() == this.getLastChild()) {
                this.\u00eb8s = null;
            } else {
                Node node = oldChild.\u00ebZPN();
                this.getLastChild().\u00ebf(node);
                node.\u00ebe(this.getLastChild());
            }
        } else {
            Node node = oldChild.\u00ebZPM();
            Node node2 = oldChild.\u00ebZPN();
            node.\u00ebf(node2);
            node2.\u00ebe(node);
            if (oldChild == this.getLastChild()) {
                this.\u00eb8s = node;
            }
        }
        oldChild.\u00ebf(null);
        oldChild.\u00ebe(null);
        oldChild.\u00ebd(null);
        if (nodeChangingArgs != null) {
            documentBase.\u00ebY(nodeChangingArgs);
        }
        return oldChild;
    }

    public void removeAllChildren() {
        \u00eb86.\u00ebI(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(23, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    Node \u00ebQ(Node node) {
        if (this.getLastChild() == null) {
            node.\u00ebe(node);
            node.\u00ebf(node);
        } else {
            Node node2 = this.getLastChild().\u00ebZPN();
            node.\u00ebe(this.getLastChild());
            node.\u00ebf(node2);
            node2.\u00ebe(node);
            this.getLastChild().\u00ebf(node);
        }
        this.\u00eb8s = node;
        node.\u00ebd(this);
        return node;
    }

    void \u00ebZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    void \u00ebY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int \u00ebP(Node node) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (\u00eb82.\u00ebG(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    Node \u00ebSt(int n) {
        int n2 = 0;
        int n3 = this.indexOf(this.getLastChild());
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Node node = this.getChild(0, n4, false);
            int n5 = node.getStart();
            int n6 = n5 + node.getTextLength();
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n >= n6) {
                n2 = n4 + 1;
                continue;
            }
            return node.\u00ebSt(n);
        }
        return null;
    }

    @Override
    int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.\u00eblB().length();
    }

    String \u00eblB() {
        return "";
    }

    String \u00eblA() {
        return this.\u00eblz().toString();
    }

    private StringBuilder \u00eblz() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            stringBuilder.append(node.getText());
        }
        return stringBuilder;
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.\u00ebZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.\u00ebY(visitor));
    }

    abstract int \u00ebZ(DocumentVisitor var1) throws Exception;

    abstract int \u00ebY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean \u00ebR(Node var1);

    Node \u00ebZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.\u00ebc(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 33 && !this.\u00ebR(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        if ((nodeChangingArgs = documentBase.\u00ebZ(node, null, this, 0)) != null) {
            documentBase.\u00ebZ(nodeChangingArgs);
        }
        if (this.getLastChild() == null) {
            node.\u00ebe(node);
            node.\u00ebf(node);
            this.\u00eb8s = node;
        } else if (bl) {
            if (node2 != null) {
                CompositeNode.\u00ebY(node, node2);
                if (node2 == this.getLastChild()) {
                    this.\u00eb8s = node;
                }
            } else {
                CompositeNode.\u00ebY(node, this.getLastChild());
            }
        } else if (node2 != null) {
            Node node3 = node2.getPreviousSibling();
            if (node3 == null) {
                node3 = this.getLastChild();
            }
            CompositeNode.\u00ebY(node, node3);
        } else {
            CompositeNode.\u00ebY(node, this.getLastChild());
            this.\u00eb8s = node;
        }
        node.\u00ebd(this);
        if (nodeChangingArgs != null) {
            documentBase.\u00ebY(nodeChangingArgs);
        }
        return node;
    }

    private static void \u00ebY(Node node, Node node2) {
        Node node3 = node2.\u00ebZPN();
        node.\u00ebe(node2);
        node.\u00ebf(node3);
        node2.\u00ebf(node);
        node3.\u00ebe(node);
    }

    @Override
    @ReservedForInternalUse
    public Node getNextMatchingNode(Node[] curNode) {
        Node node = curNode[0];
        curNode[0] = curNode[0] == this ? this.getFirstChild() : curNode[0].getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    public CompositeNode getContainer() {
        return this;
    }
}

