/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.\u00eb2L;
import asposewobfuscated.\u00eb6E;
import asposewobfuscated.\u00eb7W;
import asposewobfuscated.\u00eb7Y;
import asposewobfuscated.\u00ebA2;
import asposewobfuscated.\u00ebGC;
import asposewobfuscated.\u00ebGW;
import asposewobfuscated.\u00ebHI;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.\u00eb1P;
import com.aspose.words.\u00eb82;
import com.aspose.words.\u00eb93;
import com.aspose.words.\u00ebFB;
import com.aspose.words.\u00ebFE;
import com.aspose.words.\u00ebFW;
import com.aspose.words.\u00ebG6;
import com.aspose.words.\u00ebGO;
import com.aspose.words.\u00ebHF;
import com.aspose.words.\u00ebJW;
import com.aspose.words.\u00ebL2;
import com.aspose.words.\u00ebN2;
import com.aspose.words.\u00ebNY;
import com.aspose.words.\u00ebOU;
import com.aspose.words.\u00ebP1;
import com.aspose.words.\u00ebYM;
import com.aspose.words.\u00ebZMZ;
import com.aspose.words.\u00ebZP;
import com.aspose.words.\u00ebZQO;
import com.aspose.words.\u00ebZQW;
import com.aspose.words.\u00ebZUG;
import com.aspose.words.\u00ebZVH;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Stack;

public class DocumentBuilder
implements \u00ebFB,
\u00ebFE,
\u00ebGO {
    private Document \u00eb3s;
    private Node \u00eb1z;
    private Node \u00eb1y;
    private \u00ebZVH \u00eb1x;
    private Font \u00eb1w;
    private Stack \u00eb1v;
    private boolean \u00eb1u;
    private \u00ebZQO \u00eb1t;
    private \u00ebYM \u00ebbY;
    private RowFormat \u00eb1s;
    private CellFormat \u00ebbX;
    private Stack \u00eb1r;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.\u00ebP(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.\u00ebP(-1, 1, -1, -1);
    }

    public void moveToSection(int sectionIndex) {
        this.\u00ebP(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.\u00ebZ(this.getCurrentSection(), \u00ebZMZ.\u00ebCb(headerFooterType), 0, 0);
    }

    private void \u00ebP(int n, int n2, int n3, int n4) {
        this.\u00eb3s.ensureMinimum();
        Section section = (Section)this.\u00eb3s.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.\u00ebZ(section, n2, n3, n4);
    }

    private void \u00ebZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = \u00ebZMZ.\u00ebCa(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.\u00eb3s, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.\u00eb3s));
            }
        }
        this.\u00ebZ(story, n2, n3);
    }

    private void \u00ebZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.\u00ebZ(paragraph, n2);
    }

    void \u00ebZ(Paragraph paragraph, int n) {
        if (n == 0) {
            this.\u00ebZ(paragraph, paragraph.getFirstChild());
        } else if (n == -1) {
            this.\u00ebZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName");
        }
        \u00ebN2 \u00ebN22 = \u00eb93.\u00ebU(this.\u00eb3s, fieldName);
        if (\u00ebN22 == null) {
            return false;
        }
        this.moveToField(\u00ebN22, isAfter);
        if (isDeleteField) {
            \u00ebN22.remove();
        }
        return true;
    }

    public void moveToField(Field field, boolean isAfter) {
        Node node;
        if (isAfter) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getStart().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        \u00ebG6 \u00ebG62 = field.\u00ebaK().\u00eb8H();
        Inline inline = \u00ebG62.\u00ebnt();
        if (inline != null) {
            this.\u00ebZ(inline.\u00eb8M(), true);
        }
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new IllegalArgumentException("bookmarkName");
        }
        Node node = isStart ? \u00ebZP.\u00ebZ(this.\u00eb3s, bookmarkName) : \u00ebZP.\u00ebY(this.\u00eb3s, bookmarkName);
        if (node == null) {
            return false;
        }
        this.\u00ebZ((Paragraph)node.\u00ebZPS(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.\u00ebZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.\u00ebZT(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.\u00ebZ(cell.getFirstParagraph(), 0);
        } else if (characterIndex == -1) {
            this.\u00ebZ(cell.getLastParagraph(), -1);
        }
    }

    void \u00ebZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
        } else {
            this.moveTo(paragraph);
        }
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() != 8 && !\u00eb82.\u00ebZO(node)) {
            throw new IllegalStateException("The node must be a paragraph or an inline node.");
        }
        this.\u00ebM(node);
        if (this.getCurrentParagraph().isInCell()) {
            this.\u00ebhW();
        } else {
            this.\u00ebYr(false);
        }
        if (this.isAtEndOfParagraph()) {
            this.\u00ebhX();
        } else if (!this.\u00ebhY()) {
            this.\u00ebhX();
        }
    }

    private boolean \u00ebhY() {
        Node node = this.\u00ebhN();
        if (!(node instanceof \u00ebFW)) {
            while (node != null && !(node instanceof \u00ebFW)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.\u00ebhN(); node != null && !(node instanceof \u00ebFW); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            \u00ebFW \u00ebFW2 = (\u00ebFW)((Object)node);
            this.\u00ebZ(\u00ebFW2.getRunPr_IInline(), true);
            return true;
        }
        return false;
    }

    private void \u00ebhX() {
        this.\u00ebZ(this.getCurrentParagraph().\u00ebZIz(), true);
    }

    private void \u00ebhW() {
        Cell cell = this.getCurrentParagraph().\u00ebbN();
        Row row = cell.getParentRow();
        this.\u00eb1t = row.\u00ebZMu();
        this.\u00ebbY = cell.\u00ebp8();
        this.\u00eb1u = true;
    }

    void \u00ebYr(boolean bl) {
        if (!this.\u00eb1u) {
            return;
        }
        this.\u00ebYq(bl);
    }

    private void \u00ebYq(boolean bl) {
        this.\u00eb1u = false;
        this.\u00eb1t = bl ? (\u00ebZQO)this.\u00eb1t.\u00ebrx() : \u00ebZQO.\u00ebZs8();
        this.\u00ebbY = bl ? (\u00ebYM)this.\u00ebbY.\u00ebrx() : new \u00ebYM();
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.\u00ebZT(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.\u00ebhP() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.\u00ebhN().\u00ebc(row)) {
            boolean bl;
            boolean bl2 = bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.\u00ebZPQ();
                this.\u00ebZ(paragraph, 0);
            }
        }
        row.remove();
        if (!table.\u00eblG()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.\u00ebL(text, false);
    }

    public void writeln(String text) {
        this.\u00ebL(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = new Paragraph(this.\u00eb3s, this.\u00ebhS(), this.\u00ebhT());
        this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
        if (this.isAtEndOfParagraph()) {
            this.moveTo(paragraph);
        } else {
            paragraph.\u00ebY(this.\u00ebhN(), null, paragraph.getLastChild());
        }
        return this.getCurrentParagraph();
    }

    public void insertBreak(int breakType) {
        this.\u00ebN(breakType, true);
    }

    void \u00ebN(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.\u00ebYp(bl)) {
                    this.\u00ebUQ(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.\u00ebYp(bl)) {
                    this.\u00ebUQ(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                this.\u00ebRq(1);
                return;
            }
            case 5: {
                this.\u00ebRq(2);
                return;
            }
            case 3: {
                this.\u00ebRq(0);
                return;
            }
            case 6: {
                this.\u00ebRq(3);
                return;
            }
            case 7: {
                this.\u00ebRq(4);
                return;
            }
            case 8: {
                this.\u00ebUQ(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!\u00ebHI.\u00ebZz(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(\u00eb6E.format("TOC {0}", switches), "");
    }

    public Field insertField(String fieldCode) throws Exception {
        Field field = this.insertField(fieldCode, null);
        field.update();
        return field;
    }

    public Field insertField(String fieldCode, String fieldValue) {
        if (!\u00ebHI.\u00ebZz(fieldCode)) {
            throw new IllegalArgumentException("fieldCode is required.");
        }
        int n = \u00ebL2.\u00ebSH(fieldCode);
        return this.\u00ebX(fieldCode, fieldValue, n);
    }

    private Field \u00ebX(String string, String string2, int n) {
        FieldEnd fieldEnd;
        FieldSeparator fieldSeparator;
        FieldStart fieldStart = this.\u00ebRp(n);
        this.\u00ebUP(string);
        if (\u00ebL2.\u00ebON(n) == 2) {
            fieldSeparator = this.\u00ebRo(n);
            if (string2 != null) {
                this.\u00ebUQ(string2);
            }
            fieldEnd = this.\u00ebM(n, true);
        } else {
            fieldSeparator = null;
            fieldEnd = this.\u00ebM(n, false);
        }
        return \u00ebNY.\u00ebY(fieldStart, fieldSeparator, fieldEnd);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        \u00ebHI.\u00ebY(displayText, "displayText");
        \u00ebHI.\u00ebY(urlOrBookmark, "hrefOrBookmark");
        \u00ebP1 \u00ebP12 = this.\u00ebZ(urlOrBookmark, isBookmark, "");
        this.write(displayText);
        \u00ebP12.\u00ebY(this.\u00ebhU());
        return \u00ebNY.\u00ebY(\u00ebP12.getStart(), \u00ebP12.getSeparator(), \u00ebP12.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (format == null) {
            throw new IllegalArgumentException("format");
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.\u00ebRp(70);
        if (\u00ebHI.\u00ebZz(name)) {
            this.startBookmark(name);
        }
        this.\u00ebUP(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.\u00ebRo(70);
        String string = \u00ebHI.\u00ebZz(fieldValue) ? fieldValue : FormField.\u00ebZMi;
        Run run = new Run(this.\u00eb3s, string, this.\u00ebhT());
        this.insertNode(run);
        this.\u00ebM(70, true);
        if (\u00ebHI.\u00ebZz(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.\u00ebN(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean defaultValue, int size) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.\u00ebRp(71);
        if (\u00ebHI.\u00ebZz(name)) {
            this.startBookmark(name);
        }
        this.\u00ebUP(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.\u00ebM(71, false);
        if (\u00ebHI.\u00ebZz(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.\u00ebN(fieldEnd);
        formField.setName(name);
        formField.setChecked(defaultValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (items == null) {
            throw new IllegalArgumentException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.\u00ebRp(83);
        if (\u00ebHI.\u00ebZz(name)) {
            this.startBookmark(name);
        }
        this.\u00ebUP(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.\u00ebM(83, false);
        if (\u00ebHI.\u00ebZz(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.\u00ebN(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        boolean bl = footnoteType == 0;
        Footnote footnote = new Footnote((DocumentBase)this.\u00eb3s, footnoteType);
        footnote.getFont().setStyleIdentifier(bl ? 38 : 42);
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.\u00eb3s);
        paragraph.getParagraphFormat().setStyleIdentifier(bl ? 29 : 43);
        footnote.getParagraphs().add(paragraph);
        SpecialChar specialChar = new SpecialChar(this.\u00eb3s, '\u0002', new \u00ebZVH());
        specialChar.getFont().setStyleIdentifier(bl ? 38 : 42);
        paragraph.appendChild(specialChar);
        if (\u00ebHI.\u00ebZz(footnoteText)) {
            Node node = this.\u00ebhN();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.\u00ebM(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    Shape \u00eb5(\u00eb7W \u00eb7W2) throws Exception {
        return this.\u00ebZ(\u00eb7W2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.\u00eb5(\u00eb7W.\u00ebZ(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    Shape \u00ebZ(\u00eb7W \u00eb7W2, double d, double d2) throws Exception {
        return this.\u00ebZ(\u00eb7W2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.\u00ebZ(\u00eb7W.\u00ebZ(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new IllegalArgumentException("image");
        }
        \u00eb7Y \u00eb7Y2 = new \u00eb7Y();
        try {
            \u00ebGW.\u00ebY(image, \u00eb7Y2);
            Shape shape = this.\u00ebZ(\u00eb7Y2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (\u00eb7Y2 != null) {
                \u00eb7Y2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        \u00ebHI.\u00ebO(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = \u00ebGC.\u00ebYV(fileName);
        try {
            Shape shape = this.\u00ebZ((\u00eb7W)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((\u00eb7W)object).close();
            }
        }
    }

    Shape \u00ebZ(\u00eb7W \u00eb7W2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (\u00eb7W2 == null) {
            throw new IllegalArgumentException("stream");
        }
        byte[] byArray = \u00ebHI.\u00ebu(\u00eb7W2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.\u00ebZ(\u00eb7W.\u00ebZ(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (imageBytes == null) {
            throw new IllegalArgumentException("imageBytes");
        }
        Shape shape = new Shape(this.\u00eb3s, 75);
        shape.\u00ebU(this.\u00ebhT());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.\u00ebF(width < 0.0 ? imageSize.getWidthPoints() : width, height < 0.0 ? imageSize.getHeightPoints() : height);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        if (this.\u00ebhV()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.\u00ebUR(documentBuilder.getDocument().toString(70)));
        } else {
            \u00ebHF \u00ebHF2 = new \u00ebHF(this.getDocument().getResourceLoadingCallback(), 50);
            \u00ebHF2.\u00ebZ(html, this);
        }
    }

    private boolean \u00ebhV() {
        boolean bl = false;
        if (this.\u00ebhN().getParentNode().getNodeType() == 25) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.\u00ebhN().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String \u00ebUR(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.\u00ebhP() == null) {
            this.startTable();
        }
        if (this.\u00ebhP().\u00ebZta() == 1) {
            this.\u00ebhP().\u00ebZtd();
        }
        if (this.\u00ebhP().\u00ebZta() == 3) {
            this.\u00ebhP().\u00ebZtb();
        }
        return this.\u00ebhP().\u00ebZtc();
    }

    public Table startTable() {
        this.\u00eb1r.push(new \u00ebZQW(this));
        return this.\u00ebhP().startTable();
    }

    public Table endTable() {
        if (this.\u00ebhP() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.\u00ebhP().endTable();
        this.\u00eb1r.pop();
        return table;
    }

    public Row endRow() {
        if (this.\u00ebhP() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        return this.\u00ebhP().endRow();
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.\u00eb3s, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.\u00eb3s, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public Document getDocument() {
        return this.\u00eb3s;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value == this.\u00eb3s) {
            return;
        }
        this.\u00eb3s = value;
        this.\u00ebM(null);
        this.\u00eb1x = new \u00ebZVH();
        this.\u00eb1v = null;
        this.\u00eb1w = null;
        this.\u00ebYq(false);
        this.\u00eb1r = new Stack();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.\u00eb1w == null) {
            this.\u00eb1w = new Font(this, this.getDocument());
        }
        return this.\u00eb1w;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.\u00eb1s == null) {
            this.\u00eb1s = new RowFormat(this);
        }
        return this.\u00eb1s;
    }

    public CellFormat getCellFormat() {
        if (this.\u00ebbX == null) {
            this.\u00ebbX = new CellFormat(this);
        }
        return this.\u00ebbX;
    }

    void \u00ebO(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.\u00ebhO().push(this.\u00ebhT());
    }

    public void popFont() {
        if (this.\u00ebhO().size() > 0) {
            this.\u00ebZ((\u00ebZVH)this.\u00ebhO().pop(), false);
        }
    }

    \u00ebP1 \u00ebZ(String string, boolean bl, String string2) {
        FieldStart fieldStart = this.\u00ebRp(88);
        \u00ebOU \u00ebOU2 = new \u00ebOU();
        \u00ebOU2.setTarget(string2);
        if (bl) {
            \u00ebOU2.\u00ebTe(string);
        } else {
            \u00ebOU2.\u00ebTf(\u00ebA2.\u00ebXV(string));
            \u00ebOU2.\u00ebTe(\u00ebA2.\u00ebXU(string));
        }
        this.\u00ebUP(\u00ebOU2.toString());
        FieldSeparator fieldSeparator = this.\u00ebRo(88);
        return new \u00ebP1(fieldStart, fieldSeparator, null);
    }

    \u00ebP1 \u00eb9(String string, String string2) {
        boolean bl = \u00ebA2.\u00ebXM(string);
        String string3 = bl ? \u00ebA2.\u00ebXU(string) : string;
        return this.\u00ebZ(string3, bl, string2);
    }

    FieldEnd \u00ebhU() {
        return this.\u00ebM(88, true);
    }

    \u00ebZVH \u00ebhT() {
        return (\u00ebZVH)this.\u00eb1x.\u00ebrx();
    }

    \u00eb1P \u00ebhS() {
        return (\u00eb1P)this.getCurrentParagraph().\u00eb3f().\u00ebrx();
    }

    \u00ebZQO \u00ebhR() {
        return (\u00ebZQO)this.\u00eb1t.\u00ebrx();
    }

    \u00ebYM \u00ebhQ() {
        return (\u00ebYM)this.\u00ebbY.\u00ebrx();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.\u00ebhN(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.\u00ebhN().getNodeType() == 8;
    }

    private void \u00ebL(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("text");
        }
        String string2 = \u00ebZMZ.\u00ebK9(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.\u00ebUQ(string2.substring(n, n + n2));
                }
                this.insertParagraph();
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.\u00ebUQ(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            break;
        }
    }

    private Run \u00ebUQ(String string) {
        Run run = new Run(this.\u00eb3s, string, this.\u00ebhT());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.\u00ebhP() != null && this.\u00ebhP().\u00ebZta() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
        } else {
            this.\u00ebhN().getParentNode().insertBefore(node, this.\u00ebhN());
        }
    }

    void \u00ebRq(int n) {
        this.\u00ebYp(true);
        this.insertParagraph();
        \u00ebZUG \u00ebZUG2 = (\u00ebZUG)this.getCurrentSection().\u00ebZN1().\u00ebrx();
        Section section = new Section(this.\u00eb3s, \u00ebZUG2);
        section.getPageSetup().setSectionStart(n);
        section.appendChild(new Body(this.\u00eb3s));
        this.\u00eb3s.insertAfter(section, this.getCurrentSection());
        section.getBody().\u00ebY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
    }

    private FieldStart \u00ebRp(int n) {
        FieldStart fieldStart = new FieldStart((DocumentBase)this.\u00eb3s, this.\u00ebhT(), n);
        this.insertNode(fieldStart);
        return fieldStart;
    }

    private Run \u00ebUP(String string) {
        Run run = this.\u00ebUQ(string);
        return run;
    }

    private FieldEnd \u00ebM(int n, boolean bl) {
        FieldEnd fieldEnd = new FieldEnd((DocumentBase)this.\u00eb3s, this.\u00ebhT(), n, bl);
        this.insertNode(fieldEnd);
        return fieldEnd;
    }

    private FieldSeparator \u00ebRo(int n) {
        FieldSeparator fieldSeparator = new FieldSeparator((DocumentBase)this.\u00eb3s, this.\u00ebhT(), n);
        this.insertNode(fieldSeparator);
        return fieldSeparator;
    }

    private FormField \u00ebN(Node node) {
        FormField formField = new FormField((DocumentBase)this.\u00eb3s, new \u00ebJW(), this.\u00ebhT());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean \u00ebYp(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.\u00ebhP() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row \u00ebZT(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    void \u00ebZ(\u00ebZVH \u00ebZVH2, boolean bl) {
        this.\u00eb1x = bl ? (\u00ebZVH)\u00ebZVH2.\u00ebrx() : \u00ebZVH2;
    }

    public Node getCurrentNode() {
        return this.isAtEndOfParagraph() ? null : this.\u00ebhN();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.\u00ebhN();
        }
        return (Paragraph)this.\u00ebhN().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private \u00ebZQW \u00ebhP() {
        return this.\u00eb1r.size() > 0 ? \u00eb2L.\u00ebZ(this.\u00eb1r.peek(), \u00ebZQW.class) : null;
    }

    private Stack \u00ebhO() {
        if (this.\u00eb1v == null) {
            this.\u00eb1v = new Stack();
        }
        return this.\u00eb1v;
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectRunAttr(int fontAttr) {
        return this.\u00eb1x.\u00ebTv(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    public int getDirectRunAttrsCount() {
        return this.\u00eb1x.getCount();
    }

    @Override
    @ReservedForInternalUse
    public void getDirectRunAttrByIndex(int index, int[] key, Object[] value) {
        key[0] = this.\u00eb1x.\u00ebV9(index);
        value[0] = this.\u00eb1x.\u00ebVa(index);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().\u00eb2(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().\u00eb2(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    public void setRunAttr(int fontAttr, Object value) {
        this.\u00eb1x.\u00ebW(fontAttr, value);
    }

    @Override
    @ReservedForInternalUse
    public void clearRunAttrs() {
        this.\u00eb1x.\u00ebrz();
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectRowAttr(int key) {
        return this.\u00eb1t.\u00ebTv(key);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedRowAttr(int key) {
        return this.\u00eb1t.\u00ebTt(key);
    }

    @Override
    @ReservedForInternalUse
    public void setRowAttr(int key, Object value) {
        this.\u00eb1t.\u00ebW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void clearRowAttrs() {
        this.\u00eb1t.clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    public void resetToDefaultAttrs() {
        this.\u00eb1t = \u00ebZQO.\u00ebZs8();
    }

    @Override
    @ReservedForInternalUse
    public Object getDirectCellAttr(int key) {
        return this.\u00ebbY.\u00ebTv(key);
    }

    @Override
    @ReservedForInternalUse
    public Object fetchInheritedCellAttr(int key) {
        return this.\u00ebbY.\u00ebTt(key);
    }

    @Override
    @ReservedForInternalUse
    public void setCellAttr(int key, Object value) {
        this.\u00ebbY.\u00ebW(key, value);
    }

    @Override
    @ReservedForInternalUse
    public void clearCellAttrs() {
        this.\u00ebbY.\u00ebrz();
    }

    private Node \u00ebhN() {
        if (this.\u00eb1z != null && this.\u00eb1z.getParentNode() == null) {
            return this.\u00eb1y;
        }
        return this.\u00eb1z;
    }

    private void \u00ebM(Node node) {
        this.\u00eb1z = node;
        if (this.\u00eb1z != null) {
            this.\u00eb1y = this.\u00eb1z.getParentNode();
        }
    }
}

