/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.\u00eb82;
import com.aspose.words.\u00ebFQ;
import com.aspose.words.\u00ebGI;
import com.aspose.words.\u00ebJP;
import com.aspose.words.\u00ebUX;
import java.util.Stack;

public abstract class Node
implements Cloneable {
    private Node \u00ebZsq;
    private Node \u00ebZsp;
    private Node \u00ebZso;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.\u00ebO(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.\u00ebZsq == null) {
            return null;
        }
        if (this.\u00ebZsq.getNodeType() == 34) {
            return null;
        }
        return (CompositeNode)this.\u00ebZsq;
    }

    CompositeNode \u00ebZPS() {
        return \u00eb82.\u00ebZM(this.getParentNode()) ? this.getParentNode().\u00ebZPS() : this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.\u00ebZsq == null) {
            return null;
        }
        return this.\u00ebZsq.getDocument();
    }

    Document \u00ebaP() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            return this.\u00ebZPM();
        }
        return null;
    }

    Node \u00ebZPR() {
        Node node = \u00eb82.\u00ebZK(this.getPreviousSibling());
        if (node == null && \u00eb82.\u00ebZM(this.getParentNode())) {
            node = this.getParentNode().\u00ebZPR();
        }
        return node;
    }

    Node \u00ebZPQ() {
        Node node = \u00eb82.\u00ebZL(this.getNextSibling());
        if (node == null && \u00eb82.\u00ebZM(this.getParentNode())) {
            node = this.getParentNode().\u00ebZPQ();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            return this.\u00ebZPN();
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    boolean \u00ebZPP() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    boolean \u00ebZPO() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (\u00eb82.\u00ebZV(node)) continue;
            return false;
        }
        return true;
    }

    Node \u00ebZPN() {
        return this.\u00ebZsp;
    }

    void \u00ebf(Node node) {
        this.\u00ebZsp = node;
    }

    Node \u00ebZPM() {
        return this.\u00ebZso;
    }

    void \u00ebe(Node node) {
        this.\u00ebZso = node;
    }

    int \u00ebZPL() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (\u00eb82.\u00ebZR(this)) {
            return 3;
        }
        if (\u00eb82.\u00ebZQ(this)) {
            return 4;
        }
        if (\u00eb82.\u00ebZP(this)) {
            return 5;
        }
        if (\u00eb82.\u00ebZO(this)) {
            return 6;
        }
        return 7;
    }

    int getStart() {
        if (this.getParentNode() == null) {
            return 0;
        }
        int n = 0;
        for (Node node = this.getParentNode().getFirstChild(); node != this; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return this.getParentNode().getStart() + n;
    }

    boolean contains(int position) {
        int n = this.getStart();
        int n2 = n + this.getTextLength();
        return position >= n && position < n2;
    }

    Node \u00ebSt(int n) {
        return this.contains(n) ? this : null;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.\u00ebZ(isCloneChildren, null);
    }

    Node \u00ebZ(boolean bl, \u00ebFQ \u00ebFQ2) {
        Node node = (Node)this.memberwiseClone();
        if (this.\u00ebZsq != null) {
            node.\u00ebZsq = this.getDocument().\u00ebi7();
        }
        node.\u00ebZsp = null;
        node.\u00ebZso = null;
        if (\u00ebFQ2 != null) {
            \u00ebFQ2.\u00ebW(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    void \u00ebd(Node node) {
        this.\u00ebZsq = node != null ? node : this.getDocument().\u00ebi7();
    }

    void \u00ebO(DocumentBase documentBase) {
        this.\u00ebZsq = documentBase != null ? documentBase.\u00ebi7() : null;
    }

    boolean \u00ebc(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node;
        Node node2 = node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node = this.getPreviousSibling();
        while (node != null) {
            Node node2;
            Node node3 = node2 = node.isComposite() ? ((CompositeNode)node).getLastChild() : null;
            if (node2 == null) break;
            node = node2;
        }
        if (node == null) {
            node = this.getParentNode();
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    Node \u00ebK5(int n) {
        Node node;
        for (node = this.getNextSibling(); null != node && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    Node \u00ebK4(int n) {
        Node node;
        for (node = this.getPreviousSibling(); null != node && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    Node \u00ebVr(boolean bl) {
        return bl ? this.getNextSibling() : this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        \u00ebGI \u00ebGI2 = \u00ebJP.\u00ebNF(saveFormat);
        return \u00ebGI2.\u00ebo(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        \u00ebGI \u00ebGI2 = \u00ebJP.\u00ebV(saveOptions);
        return \u00ebGI2.\u00ebo(this);
    }

    Node \u00ebK3(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); null != compositeNode; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!\u00eb82.\u00ebZS(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    \u00ebUX \u00ebZPK() {
        Node node = this.getPreviousSibling();
        return node != null ? \u00ebUX.\u00ebK(node) : \u00ebUX.\u00ebL(this.getParentNode());
    }

    \u00ebUX \u00ebZPJ() {
        Node node = this.getNextSibling();
        return node != null ? \u00ebUX.\u00ebL(node) : \u00ebUX.\u00ebK(this.getParentNode());
    }

    boolean \u00ebb(Node node) {
        return Node.\u00ebQ(this, node);
    }

    static boolean \u00ebQ(Node node, Node node2) {
        Stack stack;
        if (node == null || node2 == null) {
            return false;
        }
        Stack stack2 = Node.\u00eba(node);
        Node node3 = (Node)Node.\u00ebZ(stack2, stack = Node.\u00eba(node2));
        if (node3 == null) {
            return false;
        }
        if (stack2.size() == 0 || stack.size() == 0) {
            boolean bl = stack.size() > 0;
            return bl;
        }
        Object e = stack2.peek();
        Object e2 = stack.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static Stack \u00eba(Node node) {
        Stack<Node> stack = new Stack<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            stack.push(node2);
        }
        return stack;
    }

    private static Object \u00ebZ(Stack stack, Stack stack2) {
        Object var2_2 = null;
        while (stack.peek() == stack2.peek()) {
            var2_2 = stack.pop();
            stack2.pop();
            if (stack.size() != 0 && stack2.size() != 0) continue;
            break;
        }
        return var2_2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 13: {
                return "GroupShape";
            }
            case 14: {
                return "Shape";
            }
            case 15: {
                return "Comment";
            }
            case 16: {
                return "Footnote";
            }
            case 17: {
                return "Run";
            }
            case 18: {
                return "FieldStart";
            }
            case 19: {
                return "FieldSeparator";
            }
            case 20: {
                return "FieldEnd";
            }
            case 21: {
                return "FormField";
            }
            case 22: {
                return "SpecialChar";
            }
            case 23: {
                return "SmartTag";
            }
            case 24: {
                return "CustomXmlMarkup";
            }
            case 25: {
                return "StructuredDocumentTag";
            }
            case 26: {
                return "GlossaryDocument";
            }
            case 27: {
                return "BuildingBlock";
            }
            case 28: {
                return "CommentRangeStart";
            }
            case 29: {
                return "CommentRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 30: {
                return "DrawingML";
            }
            case 31: {
                return "OfficeMath";
            }
            case 32: {
                return "SubDocument";
            }
            case 33: {
                return "System";
            }
            case 34: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

