/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.\u00eb7X;
import asposewobfuscated.\u00ebMR;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean \u00ebZ4b;
    private boolean \u00ebZ4a = true;
    private boolean \u00ebpz;
    private String \u00ebZ49;
    private boolean \u00ebZ48;
    private boolean \u00ebZ47 = false;
    private IWarningCallback \u00ebfj;

    protected SaveOptions() {
    }

    boolean \u00ebZAT() {
        return this.\u00ebZ4b;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean \u00eb1B() {
        return false;
    }

    boolean \u00eb2t() {
        return true;
    }

    boolean \u00ebZAS() {
        return this.\u00ebZ4a;
    }

    public String getTempFolder() {
        return this.\u00ebZ49;
    }

    public void setTempFolder(String value) {
        this.\u00ebZ49 = value;
    }

    public boolean getPrettyFormat() {
        return this.\u00ebpz;
    }

    public void setPrettyFormat(boolean value) {
        this.\u00ebpz = value;
    }

    public boolean getUseAntiAliasing() {
        return this.\u00ebZ48;
    }

    public void setUseAntiAliasing(boolean value) {
        this.\u00ebZ48 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.\u00ebZ47;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.\u00ebZ47 = value;
    }

    public IWarningCallback getWarningCallback() {
        return this.\u00ebfj;
    }

    public void setWarningCallback(IWarningCallback value) {
        this.\u00ebfj = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.\u00ebOn(\u00ebMR.\u00eb2(\u00eb7X.\u00ebX4(fileName))));
    }
}

