package cn.wise.sc.acquisition.business.constant;

import cn.wise.im.common.exception.assertion.BusinessExceptionAssert;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * <p>返回结果</p>
 */
@Getter
@AllArgsConstructor
public enum Rcode implements BusinessExceptionAssert {


    /**
     * 用统一状态码
     */
    NOT_LOGIN(401, "用户未登录"),
    NOT_PARAM(402, "参数错误"),
    NOT_SQL(403, "SQL错误"),
    NOT_FOUND(404, "未找到相应信息"),
    NOT_REDIS(405, "未找到相应信息"),

    ;

    /**
     * 返回码
     */
    private int code;
    /**
     * 返回消息
     */
    private String message;
}
