package cn.wise.sc.acquisition.business.controller;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.service.IDataStatisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Api(tags = "数据统计")
@RestController
@RequestMapping("/business/data-statistics")
@Validated
public class DataStatisticsController {

	@Autowired
	private IDataStatisticsService dataStatisticsService;


	@ApiOperation(value = "统计概览-检测项数量统计")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "type", value = "类型1:图 2:表", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "cycle", value = "统计周期1:本周 2:本月 3:本季度，4:本年", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String")
	})
	@GetMapping("/countByPhoto")
	public R countByPhoto(Integer type, String TruckID, Integer cycle, String startDate, String endDate) {
		Rcode.NOT_PARAM.assertNotNull(type);
		if(type == 1){
			return dataStatisticsService.countByPhoto(TruckID, cycle, startDate, endDate);
		}else if(type == 2){
			return dataStatisticsService.countByTable(TruckID, cycle, startDate, endDate);
		}else{
			return R.fail(402, "参数错误");
		}
	}




}

