package cn.wise.sc.acquisition.business.controller;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TSysUser;
import cn.wise.sc.acquisition.business.service.ITSysUserService;
import cn.wise.sc.acquisition.business.service.impl.LoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "登录接口")
@RestController
@RequestMapping("/login")
public class LoginController {

    @Autowired
    private LoginService loginService;
    @Autowired
    private ITSysUserService userService;


    @ApiOperation(value = "登录")
    @GetMapping("/getToken")
    public R getToken(String userName, String password) {
        return loginService.login(userName, password);
    }


    @ApiOperation(value = "当前登录用户")
    @GetMapping("/getLoginUser")
    public R getLoginUser() {
        return userService.getLoginUser();
    }



//    @Autowired
//    private ITEquipmentAccountService  equipmentAccountService;

    @ApiOperation(value = "测试接口")
    @GetMapping("/testSave")
    public R testSave() {
        //用户
        TSysUser user = new TSysUser();
        user.setName("竹天卫").setLoginID("zhutianwei"+userService.count()+1).setPassword("123456").setDeptID("1").setRoleID(1);
        Boolean ref = userService.save(user);
        Rcode.NOT_SQL.assertIsFalse(!ref);
        //设备台账
       /* TEquipmentAccount tEquipmentAccount = new TEquipmentAccount();
        tEquipmentAccount.setEquipmentName("aa").setProcessesName("aa").setEquipmentType("租赁").setEquManager("张三")
                .setGgxh("a").setScnl("a");
        equipmentAccountService.save(tEquipmentAccount);*/
       return R.ok(user);
    }




}
